/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h1C0
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor="#ffffff", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var btn:Sprite;
        private var help:HelpPanel;
        private var deceleration:Number = 0.25;
        
        public function FlashTest() {
           stage.scaleMode = StageScaleMode.NO_SCALE;
           stage.align = StageAlign.TOP_LEFT;
           init();            
        }
        
        private function init():void {
            btn = new Sprite();
            addChild(btn);
            btn.x = 232;
            btn.y = 232;
            btn.graphics.beginFill(0xff0000);
            btn.graphics.drawRect(-50, -50, 100, 100);
            btn.graphics.endFill();
            btn.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            btn.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            
            help = new HelpPanel();
            addChild(help);
            help.x = 232;
            help.y = 532;
            help.text = "help!";            
        }
        private function rollOver(evt:MouseEvent):void {
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            help.x += (stage.mouseX - help.x) * deceleration;
            help.y += (stage.mouseY - help.y) * deceleration;
        }
        private function rollOut(evt:MouseEvent):void {
            removeEventListener(Event.ENTER_FRAME, update);
            help.x = 232;
            help.y = 532;
        }
    }
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.events.MouseEvent;

class HelpPanel extends Sprite {
    private var base:Sprite;
    private var panel:Shape;
    private var arrow:Shape;
    private var board:Shape;
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var px:uint;
    private var py:uint;
    private var _width:uint = 100;
    private var _height:uint = 30;
    private static var xOffset:uint = 15;
    private static var yOffset:uint = 10;
    private static var bColor:uint = 0xffffff;
    private static var sColor:uint = 0x000000;
    private static var cColor:uint = 0xeeeeee;
    private static var tColor:uint = 0x000000;
    private var shade:DropShadowFilter;
    
    public function HelpPanel() {
        init();
    }
    
    private function init():void {
        mouseChildren = false;
        mouseEnabled = false;
        draw();
    }
    private function draw():void {;
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 1.5, 2, false, false);
        base = new Sprite();
        panel = new Shape();
        arrow = new Shape();
        board = new Shape();
        txt = new TextField();
        addChild(base);
        base.addChild(panel);
        base.addChild(arrow);
        base.addChild(board);
        base.addChild(txt);
        createBox(panel, -_width*0.5, -_height, _width, _height, 4);
        createArrow(arrow, 6, 8);
        createBase(board, -_width*0.5+5, -_height+5, _width-10, _height-10);
        base.y = -yOffset;
        txt.x = -_width*0.5 + 8;
        txt.y = -_height + 6;
        txt.width = _width - 16;
        txt.height = _height - 2;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.multiline = true;
        txt.wordWrap = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        filters = [shade];
    }
    
    public function set text(param:String):void {
        txt.text = param;
    }
    private function createBox(target:Shape, x:int, y:int, w:uint, h:uint, c:uint):void
    {
        target.graphics.beginFill(bColor);
        target.graphics.drawRoundRect(x, y, w, h, c*2);
        target.graphics.endFill();        
    }
    private function createArrow(target:Shape, w:uint, h:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.moveTo(0, 0);
        target.graphics.lineTo(-w*0.5, 0);
        target.graphics.lineTo(0,h);
        target.graphics.lineTo(w*0.5, 0);
        target.graphics.lineTo(0, 0);
        target.graphics.endFill();
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint):void
    {
        target.graphics.beginFill(cColor);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }
}
