/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h18C
 */

package 
{
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    [SWF(width = 465, height = 465)]
    public class Soundtest19 extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var arr:Array = [];
        private var sp_array:Array = [];
        
        private var switcher:Boolean = true;
        
        public function Soundtest19():void 
        {
            //graphics.beginFill(0x000000);
            //graphics.drawRect(0, 0, 465, 465);
            //graphics.endFill();
            
            
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10);
            sp_array = lineDraw();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            for (var i:int = 0; i < 512; i++)
            {
                var sp:Sprite = sp_array[i] as Sprite;
                var data:Number = bytes.readFloat() * 300;
                sp.x += (data - sp.x) + 465 / 2;
                
                //if (sp.x > stage.stageWidth)
                //{
                    //sp.x = 0;
                //}
                
            }
        }
        
        private function lineDraw():Array
        {
            var master_arr:Array = [];
            for (var i:int = 0; i < 32; i++)
            {
                for (var j:int = 0; j < 16; j++)
                {
                    var sp:Sprite = new Sprite();
                    var _width:Number = stage.stageWidth / 32;
                    var _height:Number = stage.stageHeight / 16;
                    sp.graphics.beginFill(0xFFFFFF);
                    //sp.graphics.lineStyle(0.5, 0xFFFFFF, 0.4);
                    sp.graphics.lineStyle(0.5, 0, 0.4);
                    sp.graphics.drawRect(0,0,2,_height);
                    sp.graphics.endFill();
                    sp.x = _width * i;
                    sp.y = _height * j; +_height / 2;
                    addChild(sp);
                    master_arr.push(sp);
                }
            }
            return master_arr;
        }
    }
}