/**
 * Copyright arumajirou ( http://wonderfl.net/user/arumajirou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h0sg
 */

    package {
	import flash.accessibility.Accessibility;
	import flash.events.*;
    import flash.display.Sprite;
    import flash.geom.*;
    import flash.text.*;

        
    [SWF(width="200", height="200", backgroundColor="0x330000")]

        public class FlashTest extends Sprite {
    		static public var chara : listSprite = null;
    		static public var canvas : Sprite;
    		
    		public var tex : TextField = undefined;
    		private var tf : TextFormat = undefined;
    		
    		private var pp : player = null;

    		static public function addChara( t : listSprite ) : void
    		{
    			FlashTest.chara.add( t );
    			FlashTest.canvas.addChild( t );
    		}
    		
    		static public function removeChara( t : listSprite ) : void
    		{
    			t.remove();
    			FlashTest.canvas.removeChild( t );
    		}
    		           
		public function FlashTest() {
            // write as3 code here..
            FlashTest.canvas = this;
            listSprite.count = 1;
            
            tf = new TextFormat( null, 11, 0xffffff );
            tf.align = TextFormatAlign.LEFT;
            
            tex = new TextField();
            tex.setTextFormat( tf );
            tex.x = 0;
            tex.y = 0;
            tex.text = "test";
            addChild( tex );

            FlashTest.chara = new listSprite();
            FlashTest.addChara( pp = new player() );

			parent.addEventListener( MouseEvent.MOUSE_MOVE, onRelease );
			parent.addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }

                
        private function onRelease( e : MouseEvent ) : void
        {
//        		if( e.buttonDown == false ) return;
        		
    			pp.move( new Vector3D( e.stageX, e.stageY, 0, 1 ) );
        }
        
        private function onEnterFrame( e : Event ) : void
        {
        		var t : listSprite = chara;

        		var cnt : int = 0;        		
        		while( t != null )
        		{
        			var res : Boolean = t.poll();
        			if( res == false )
        			{
					FlashTest.removeChara( t );
        			}
        			t = t.getNext();

				cnt++;
        		}
        		
        		tex.text = cnt.toString();
        }
    }
}

	class listSprite extends Sprite
	{
		public static var count : int;
		
		private var prev : listSprite;
		private var next : listSprite;
		
		function listSprite()
		{
			prev = null;
			next = null;
		}
		
		public function setPrev( o : listSprite ) : void
		{
			prev = o;
		}
		
		public function setNext( o : listSprite ) : void
		{
			next = o;
		}
		
		public function getPrev() : listSprite
		{
			return prev;
		}
		
		public function getNext() : listSprite
		{
			return next;
		}
		
		public function add( o : listSprite ) : void
		{
			if( o == null ) return;
			if( next != null )
			{
				next.setPrev( o );
			}
			o.setNext( next );
			next = o;
			o.setPrev( this );
			
			listSprite.count++;
		}
		
		public function remove() : void
		{
			prev.setNext( next );
			if( next != null )
				next.setPrev( prev );
				
			listSprite.count--;
		}
		
		public function poll() : Boolean
		{
			return true;
		}
	}
	
	
    import flash.display.Sprite;
	import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    class player extends listSprite
    {
    		public static var MOVE : Number = 2;
    		private var moves : Vector3D;
    		private var moveCount : Number;
    		
    		private var bl : bullet = undefined;
    		
    		public function player()
    		{
    			graphics.clear();
    			graphics.beginFill( 0xffff00 );
    			graphics.lineStyle( 1, 0xffff00 );
    			graphics.drawCircle( 0, 0, 10 );
    			graphics.endFill();
    			
    			moves = new Vector3D( 0, 0, 0, 1 );
    			moveCount = 0;
    			
    			bl = null;
    		}
    		
    		public function move( des : Vector3D ) : void
    		{
    			var np : Vector3D = new Vector3D( x, y, 0, 1 );
    			var m : Vector3D = des.subtract( np ).clone();
    			moveCount = Math.round( Math.sqrt( m.dotProduct( m ) ) / player.MOVE );
    			m.normalize();
    			bl = new bullet( np, m );
    			FlashTest.addChara( bl );
    			m.scaleBy( player.MOVE );
    			moves = m.clone();
    			
    		}
    		
    		public override function poll() : Boolean
    		{
    			if( moveCount <= 0 ) return true;
    			x = x + moves.x;
    			y = y + moves.y;
    			moveCount--;
    			
    			return true;
    		}
    }
    
    

    
    class bullet extends listSprite
    {
    		public static var MOVE : Number = 5;
    		private var moves : Vector3D;
    		private var moveCount : Number;
    		
    		public function bullet( p : Vector3D, v : Vector3D )
    		{
    			graphics.clear();
    			graphics.beginFill( 0xffff00 );
    			graphics.lineStyle( 1, 0xffffff );
    			graphics.drawCircle( 0, 0, 2 );
    			graphics.endFill();

    			moves = v.clone();
   			moves.scaleBy( bullet.MOVE );
    			moveCount = 50;
    			x = p.x;
    			y = p.y;
    		}
    		
    		public override function poll() : Boolean
    		{
    			if( moveCount <= 0 )
    			{
    				return false;
    			}
    			
    			x = x + moves.x;
    			y = y + moves.y;
    			moveCount--;
    			
    			return true;
		}
    }
