/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h0eR
 */

/**
* http://moock.org/lectures/mvc/ 
*/
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var m:ClockModel = new ClockModel();
            var ctrl:ClockTool = new ClockTool(m);
            var clock:ClockView = new ClockView(m);
            
            m.addObserver(ctrl);
            m.addObserver(clock);
            
            ctrl.y = 100;
            
            m.setTime(10,0,0);
            m.start();
            
            addChild(clock)
            addChild(ctrl);
        }
    }
}

////////////////////////////////////////////////////////////////
import com.bit101.components.*;
import flash.events.*;
import flash.display.*;

class Observable{
    private var _observers:Array;
    public function Observable(){
        _observers = [];
    }
    public function addObserver(o:Observer):void{
        var i:int = _observers.indexOf(o);
        if(i==-1) _observers.push(o);
    }
    public function removeObserver(o:Observer):void{
        var i:int = _observers.indexOf(o);
        if(i!=-1) _observers.splice(i,1);
    }
    public function notifyObservers(info:*):void{
        for each( var o:Observer in _observers ) {
            o.update(this,info);
        }
        _isChanged = false;
    }
    private var _isChanged:Boolean = false;
    public function setChanged():void{
        _isChanged = true;
    }
    public function get hasChanged():Boolean{ return _isChanged; } 
}

interface View{
    function get model():Observable;
    function set model(m:Observable):void;
    function get controller():Controller;
    function set controller(c:Controller):void;
    function defaultController(m:Observable):Controller;
}

interface Controller{
    function get model():Observable;
    function set model(m:Observable):void;
    function get view():View;
    function set view(v:View):void;
}

interface Observer{
    function update(o:Observable, info:*):void;
}

class AbstructView extends Sprite implements View, Observer{
    private var _model:Observable;
    private var _controller:Controller;
    
    public function AbstructView(m:Observable, c:Controller=null){
        model = m;
        if(c!=null) controller = c;
    }
    
    public function get model():Observable{ return _model; }
    public function set model(m:Observable):void{ _model = m; }
    
    public function get controller():Controller{ 
        if(_controller==null){
            controller = defaultController(model);
        }
        return _controller;
    }
    public function set controller(c:Controller):void{
         _controller = c;
         controller.view = this;
    }
    
    public function defaultController(m:Observable):Controller{
        return null;
    }
    
    public function update(o:Observable,info:*):void{
        
    }
}

class AbstructCotnroller implements Controller {
    private var _model:Observable;
    private var _view:View;
    
    public function AbstructCotnroller(m:Observable){
        model = m;
    }
    public function get model():Observable{ return _model; }
    public function set model(m:Observable):void{ _model = m; }
    
    public function get view():View{ return _view; }
    public function set view(v:View):void{ _view = v; }
}

//////////////////////////////////////////////////////////
import flash.utils.setInterval;
import flash.utils.clearInterval;

class ClockUpdate{
    public var hour:int;
    public var minute:int;
    public var second:int;
    public var isRunning:Boolean;
    public function ClockUpdate(h:int,m:int,s:int,isRunning:Boolean){
        hour = h;
        minute = m;
        second = s;
        this.isRunning = isRunning;
    }
}

class ClockModel extends Observable{
    private var _hour:int;
    private var _minute:int;
    private var _second:int;
    
    private var _tickInterval:int;
    private var _isRunning:Boolean;
    public function ClockModel(){
        super();
        var now:Date = new Date();
        setTime(now.getHours(),now.getMinutes(),now.getSeconds());
    }
    public function setTime(h:int,m:int,s:int):void{
        if( h != _hour && isValidHour(h) ) {
            _hour = h;
            setChanged();
        }
        if( m != _minute && isValidMinute(m) ) {
            _minute = m;
            setChanged();
        }
        if( s != _second && isValidSecond(s) ) {
            _second = s;
            setChanged();
        }
        
        if(hasChanged){
            var info:ClockUpdate = new ClockUpdate(_hour,_minute,_second,_isRunning);
            notifyObservers(info);
        }
    }
    
    public function start():void{
        if( !_isRunning ) {
            _isRunning = true;
            _tickInterval = setInterval( tick, 1000);
            
            var info:ClockUpdate = new ClockUpdate(_hour,_minute,_second,_isRunning);
            setChanged();
            notifyObservers(info);
        }
    }
    public function stop():void{
        if( _isRunning ) {
            _isRunning = false;
            clearInterval(_tickInterval);
            
            var info:ClockUpdate = new ClockUpdate(_hour,_minute,_second,_isRunning);
            setChanged();
            notifyObservers(info);
        }
    }
    
    private function isValidHour(value:int):Boolean{
        return value >= 0 && value < 24;
    }
    private function isValidMinute(value:int):Boolean{
        return value >= 0 && value < 60;
    }
    private function isValidSecond(value:int):Boolean{
        return value >= 0 && value < 60;
    }
    
    private function tick():void{
        var h:int = _hour;
        var m:int = _minute;
        var s:int = _second;

        s += 1;
        if (s > 59) {
            s = 0;
            m += 1;
            if (m > 59) {
                m = 0;
                h += 1;
                if (h > 23) {
                    h = 0;
                }
            }
        }
        setTime(h, m, s);
    }
}
import flash.text.TextField;

class ClockView extends AbstructView{
    public var textField:TextField;
    public function ClockView(m:Observable,c:Controller=null){
        super(m,c);
        
        addChild(textField = new TextField());
    }
    override public function update(o:Observable,info:*):void{
        var update:ClockUpdate = info as ClockUpdate;
        if( update == null ) return;
        textField.text = [ update.hour, update.minute, update.second ].join(':');
    }
}
class ClockController extends AbstructCotnroller{
    public function ClockController(m:Observable){
        super(m);
    }
    
    public function startClock():void{
        ClockModel(model).start();
    }
    public function stopClock():void{
        ClockModel(model).stop();
    }
    public function resetClock():void{
       setTime(0,0,0);
    }
    
    public function setTime (h:int, m:int, s:int):void {
        ClockModel(model).setTime(h, m, s);
    }
}

class ClockTool extends AbstructView {
    public var btnStart:PushButton;
    public var btnStop:PushButton;
    public var btnReset:PushButton;
    public function ClockTool(m:Observable,c:Controller=null){
        super(m,c);
        var ctrl:ClockController = ClockController(controller);
        
        btnStart = new PushButton(this,0,0,'start',function():void{ctrl.startClock();});
        btnStop = new PushButton(this,110,0,'stop',function():void{ctrl.stopClock();});
        btnReset = new PushButton(this,220,0,'reset',function():void{ctrl.resetClock();});
    }
    
    override public function update(m:Observable,info:*):void{
        var update:ClockUpdate = info as ClockUpdate;
        if(update.isRunning){
            btnStart.mouseEnabled = false;
            btnStop.mouseEnabled = true;
        }
        else {
            btnStart.mouseEnabled = true;
            btnStop.mouseEnabled = false;
        }
    }
    override public function defaultController(m:Observable):Controller{
         return new ClockController(m);
    }
}
