/**
 * Copyright tripu ( http://wonderfl.net/user/tripu )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/h0dI
 */

package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.FileReference;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    [SWF(width='500', height='500', backgroundColor='#000000', frameRate='30')]
    public class BlackAndWhiteHalftoning extends Sprite {
        
        protected var _loader:Loader;
        protected var _fileReference:FileReference;
        protected var _bitmap:BitmapData;
        protected var _distortion:int = 50;
        protected var _decreasing:Boolean = true;
        
        public function BlackAndWhiteHalftoning() {
            
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            _loader.load (new URLRequest('http://tripu.info/flash/sample.jpeg'), new LoaderContext(true));
            
        }
        
        protected function init(e:Event):void {

            if (!_bitmap) {
                _bitmap = new BitmapData(500,500, false, 0);
                addChild(new Bitmap(_bitmap, 'auto', true));
                addEventListener(Event.ENTER_FRAME, onRun);
                _fileReference = new FileReference();
                _fileReference.addEventListener(Event.SELECT, onFileSelected);
                _fileReference.addEventListener(Event.COMPLETE, onFileLoaded);
                stage.addEventListener(MouseEvent.CLICK, loadUserImage);
            } else {
                _bitmap.fillRect (_bitmap.rect, 0);
            }

//            var bd:BitmapData = _loader.content["bitmapData"];
//
//            for (var i:uint = 0; i < _bitmap.width; i ++) {
//                for (var j:uint = 0; j < _bitmap.height; j ++) {
//                    _bitmap.setPixel(i, j, bd.getPixel(Math.random() * 40 + i, Math.random() * 40 + j));
//                }
//            }

        }
        
        protected function loadUserImage(e:MouseEvent):void {
            _fileReference.browse();
        }
        
        protected function onFileSelected(e:Event):void {
            _fileReference.load();
        }
        
        protected function onFileLoaded(e:Event):void {
            _loader.loadBytes(_fileReference.data);
        }

        protected function onRun(evt:Event):void {

            if (_bitmap && _loader && _loader.content) {
            var bd:BitmapData = _loader.content["bitmapData"];
            for (var i:uint = 0; i < _bitmap.width; i ++) {
                for (var j:uint = 0; j < _bitmap.height; j ++) {
                    _bitmap.setPixel(i, j, bd.getPixel(Math.random() * _distortion + i - _distortion * 0.5, Math.random() * _distortion + j - _distortion * 0.5));
                }
            }

            if (_decreasing) {
                _distortion --;
                if (_distortion < 0) {
                    _decreasing = false;
                }
            } else {
                _distortion ++;
                if (_distortion > 50) {
                    _decreasing = true;
                }
            }
            }

/*            if (_bitmap) {

                for (var i:uint = 0; i < _bitmap.width; i ++) {
                    for (var j:uint = 0; j < _bitmap.height; j ++) {
                        _bitmap.setPixel(i, j, ~_bitmap.getPixel(i, j));
                    }
                }

            }*/

        }
        
    }
    
}

// EOF

