/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h0JH
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Atomic extends Sprite
    {
        public static const W:uint = 465;
        public static const H:uint = 465;
        public static const C:uint = 100;
        
        public function Atomic()
        {
            super();
            
            for(var i:uint = 0; i < C; i++)
                addChild(new Particle(
                    Math.random() * W,
                    Math.random() * H,
                    Math.random() * Particle.MAX_RADIUS + 1
                ));
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(event:Event):void
        {
            graphics.clear();
            
            var i:uint, j:uint;
            var l:uint = Particle.list.length;
            var p1:Particle, p2:Particle;
            var d:Number, dx:Number, dy:Number;
            
            for(i = 0; i < l; i++)
            for(j = i + 1; j < l; j++)
            {
                p1 = Particle.list[i];
                p2 = Particle.list[j];
                dx = p1.x - p2.x;
                dy = p1.y - p2.y;
                d = dx * dx + dy * dy;
                
                if(d < 2000)
                {
                    graphics.lineStyle(1, 0, 1 / d * 100);
                    graphics.moveTo(p1.x, p1.y);
                    graphics.lineTo(p2.x, p2.y);
                }
            }
        }
    }
}


import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

internal class Particle extends Shape
{
    public static var list:Vector.<Particle> = new Vector.<Particle>();
    public var radius:Number = 0;
    
    private static const MAX_SPEED:Number = 1;
    private static const ACCELERATION:Number = 0.95;
    public static const MAX_RADIUS:Number = 5;
    
    private var speedX:Number = 0;
    private var speedY:Number = 0;
    
    public function Particle(x:Number, y:Number, radius:Number):void
    {
        this.x = x;
        this.y = y;
        this.radius = radius;
        
        graphics.beginFill(0, 1);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        list.push(this);
        addEventListener(Event.ENTER_FRAME, enterFrame);
        
        speedX = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        speedY = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
    }
    
    private function enterFrame(event:Event):void
    {
        var dx:Number, dy:Number, c:Number;
        for each(var particle:Particle in list)
        if(particle != this)
        {
            c = Atomic.C / particle.radius / particle.radius;
            speedX += calc(x, particle.x) / c;
            speedY += calc(y, particle.y) / c;
        }
        
        //speedX += calc(x, Atomic.W) + calc(x);
        //speedY += calc(y, Atomic.H) + calc(y);
        
        speedX *= ACCELERATION;
        speedY *= ACCELERATION;
        x += speedX;
        y += speedY;
        
        if(x > Atomic.W)
            x -= Atomic.W;
        if(x < 0)
            x += Atomic.W;
        if(y > Atomic.H)
            y -= Atomic.H;
        if(y < 0)
            y += Atomic.H;
    }
    
    private function calc(x1:Number, x2:Number = 0):Number
    {
        var d:Number = x1 - x2;
        return d ? 1 / d : 0;
    }
}
