/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h07V
 */

package {

    import flash.display.Sprite;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextLine;
    import flash.text.engine.TextElement;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.ContentElement;
    import flash.text.engine.GroupElement;
    import flash.text.engine.TextLineMirrorRegion;
    import flash.events.MouseEvent;
    import flash.events.EventDispatcher;
    import flash.ui.Mouse;

    public class TextLineMirrorRegionExample extends Sprite {
        
        private var myEvent:EventDispatcher = new EventDispatcher();
        private var fontDescription:FontDescription = new FontDescription();
        private var textBlock:TextBlock = new TextBlock();

        public function TextLineMirrorRegionExample():void {
            
            fontDescription.fontWeight = "bold";
            var blackFormat:ElementFormat = new ElementFormat();
            blackFormat.fontSize = 18;
            blackFormat.color = 0x000000;
            blackFormat.fontDescription = fontDescription;
            
            var textElement1:TextElement = new TextElement("Click on different parts of me to find the ", blackFormat);
            var textElement2:TextElement = new TextElement("mirror regions",blackFormat);
            var textElement3:TextElement = new TextElement(". If I am a mirror region, I'll ",blackFormat);
            var textElement4:TextElement = new TextElement("turn red",blackFormat);
            var textElement5:TextElement = new TextElement(".",blackFormat);
            
            myEvent.addEventListener("click", clickHandler);
            myEvent.addEventListener("mouseOut", mouseOutHandler);
            myEvent.addEventListener("mouseOver", mouseOverHandler);
            
            var groupVector:Vector.<ContentElement> = new Vector.<ContentElement>;
            groupVector.push(textElement1, textElement2, textElement3, textElement4, textElement5);
            var groupElement:GroupElement = new GroupElement(groupVector);
            
            textElement2.eventMirror=myEvent;
            textElement4.eventMirror=myEvent;
            
            textBlock.content = groupElement;
            createLines(textBlock);
        }
    
        private function clickHandler(event:MouseEvent):void
        {
            var redFormat:ElementFormat = new ElementFormat();
            redFormat.color = 0xCC0000;
            redFormat.fontSize = 18;
            redFormat.fontDescription = fontDescription;
            var line:TextLine = event.target as TextLine;
            var region:TextLineMirrorRegion = line.getMirrorRegion(myEvent);
            region.element.elementFormat = redFormat;
            createLines(textBlock);
        }
        
        private function mouseOverHandler(event:MouseEvent):void
        {
            Mouse.cursor = "button";
        }
        
        private function mouseOutHandler(event:MouseEvent):void
        {
            Mouse.cursor = "arrow";
        }
            
        private function createLines(textBlock:TextBlock):void 
        {
            var purgeLine:TextLine = textBlock.firstLine;
                
            while (purgeLine)
            {
                removeChild (purgeLine);
                purgeLine = purgeLine.nextLine;
            }
            var lineWidth:Number = 150;
            var xPos:Number = 15.0;
            var yPos:Number = 20.0;
            var textLine:TextLine = textBlock.createTextLine (null, lineWidth);
                
            while (textLine)
            {
                textLine.x = xPos;
                textLine.y = yPos;
                yPos += textLine.height + 2;
                addChild (textLine);
                textLine = textBlock.createTextLine (textLine, lineWidth);
            }
        }
    }
}