/**
 * Copyright inamori ( http://wonderfl.net/user/inamori )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h00k
 */

package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.Timer;
    
    import org.libspark.betweenas3.BetweenAS3;

    [SWF (width='500',height='500')]
    public class FizzBuzz_1 extends Sprite {
        private var tf:TextField;
        private var tf1:TextField;
        private var tf2:TextField;
        private var c1:Clock;
        private var c2:Clock;
        private var count:int = 0;
        public function FizzBuzz_1() {
            c1 = new Clock(3,160,0x0099ff);
            addChild(c1);
            c2 = new Clock(5,100,0xff9900);
            addChild(c2);
            
            tf = createTf(30,0);
            tf1 = createTf(30,0x0099ff);
            tf2 = createTf(24,0xff9900);
            addChild(tf);
            addChild(tf1);
            addChild(tf2);
            tf.x = 250-tf.width*0.5;
            tf.y = 230;
            tf1.x = 250-tf1.width*0.5;;
            tf1.y = 40;
            tf2.x = 250-tf2.width*0.5;
            tf2.y = 110;
            tf1.text = "Fizz!";
            tf2.text = "Buzz!";
            tf1.visible = false;
            tf2.visible = false;
            tf.text = String(count);
            
            var timer:Timer = new Timer(500);
            timer.start();
            timer.addEventListener(TimerEvent.TIMER, onSecond);
        }
        private function createTf(size:int,color:uint):TextField
        {
            var tf:TextField = new TextField;
            var fm:TextFormat = new TextFormat;
            fm.size = size;
            fm.font = "Arial";
            fm.align = TextFormatAlign.CENTER;
            fm.color = color;
            tf.defaultTextFormat = fm;
            return tf;
        }
        private function onSecond(e:TimerEvent):void
        {
            c1.onSecond(e);
            c2.onSecond(e);
            count++;
            if(count%(3*5)==0)
            {
                tf1.visible = true;
                tf2.visible = true;
            }
            else if(count%(3)==0)
            {
                tf1.visible = true;
                tf2.visible = false;
            }
            else if(count%(5)==0)
            {
                tf1.visible = false;
                tf2.visible = true;
                BetweenAS3.tween(tf2,null,{$y:-5},0.3).play();
            }
            else
            {
                tf1.visible = false;
                tf2.visible = false;
            }
            tf.text = String(count);
            if(tf1.visible)BetweenAS3.tween(tf1,{y:40},{y:30},0.5).play();
            if(tf2.visible)BetweenAS3.tween(tf2,{y:110},{y:100},0.5).play();
        }
    }
    
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.osmf.events.TimeEvent;

class Clock extends Sprite
{
    private var _sep:int;
    private var arcs:Array;
    private var needle:Sprite;
    public function Clock(sep:Number,r:int,color:uint)
    {
        super();
        _sep = sep;
        arcs = [];
        
        var d:Number = -90;
        const range:Number = 360/(sep*2);
        for (var i:int = 1; i <=sep; i++) 
        {
            var a:Sprite = createArc(15,r,color,d,range);
            if(i!=1)a.alpha = 0.3;
            arcs.push( addChild(a) );
            d += 360/sep;
        }
        
        var nThick:Number = 15;
        needle = new Sprite;
        needle.graphics.beginFill(color);
        needle.graphics.drawRect(-nThick*0.5,-r*0.8,nThick,r*0.5);
        //addChild(needle);
        /*
        var timer:Timer = new Timer(1000);
        timer.start();
        timer.addEventListener(TimerEvent.TIMER, onSecond);
        */
        tick();
        
        x = 250;
        y = 250;
    }
    private var cnt:int = 1;
    public function onSecond(e:TimerEvent):void
    {
        //arcs[(cnt%_sep)].alpha -= 0.3;
        BetweenAS3.tween(arcs[(cnt%_sep)],
            {_blurFilter:{blurX:0, blurY:0} },{scaleX:1.1,scaleY:1.1,_blurFilter:{blurX:5,blurY:5} },
            0.5).play();
        //BetweenAS3.apply(arcs[(cnt%_sep)],null,{scaleX:1.1,scaleY:1.1},1).play();
        cnt++;
    }
    
    private function tick():void
    {
        var t:ITween = BetweenAS3.tween(needle,{rotation:360},null,_sep);
        t.onComplete = tick;
        t.play();
    }
    
    private function createArc(thick:Number, R:Number, color:uint, centerDegree:Number, rangeDgree:Number):Sprite
    {
        var arc:Sprite = new Sprite;
        arc.graphics.lineStyle(thick,color);
        arc.graphics.drawCircle(0,0,R);
        
        var m:Sprite = new Sprite;
        arc.addChild(m);
        var radian:Number;
        var startRadian:Number = Math.PI*(centerDegree-rangeDgree*0.5)/180;
        var endRadian:Number = Math.PI*(centerDegree+rangeDgree*0.5)/180;
        radian = startRadian;
        m.graphics.beginFill(0);
        m.graphics.moveTo(Math.cos(radian)*(R-10),Math.sin(radian)*(R-10));
        m.graphics.lineTo(Math.cos(radian)*(R+100),Math.sin(radian)*(R+100));
        radian = endRadian;
        m.graphics.lineTo(Math.cos(radian)*(R+100),Math.sin(radian)*(R+100));
        m.graphics.lineTo(Math.cos(radian)*(R-10),Math.sin(radian)*(R-10));
        radian = startRadian;
        m.graphics.lineTo(Math.cos(radian)*(R-10),Math.sin(radian)*(R-10));
        arc.mask = m;
        
        return arc;
    }
}
