/**
 * Copyright stenpel ( http://wonderfl.net/user/stenpel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gzs0
 */

package {
    import caurina.transitions.Tweener;

    import flash.events.*;
    import flash.utils.Timer;

    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.typography.Text3D;
    
    public class Text3DSample extends BasicView {
	private var _mat:Letter3DMaterial;
	private var _word:Text3D;
	private var _timer:Timer;
	private var textnum:int = 0;

		public function Text3DSample(){
		    _mat = new Letter3DMaterial();
		    _mat.fillColor = 0xFF0000;
		    _mat.doubleSided = true;

		    _word = new Text3D("HelloWorld!", new HelveticaBold(), _mat);
		    scene.addChild(_word);

		    for each(var text:DisplayObject3D in _word.letters) {
			    text.extra = {x:text.x, y:text.y, z:text.z};
			    text.x = 0;
			    text.y = 0;
			    text.z = -500;
			}

		    _timer = new Timer(1000, _word.letters.length);
		    _timer.addEventListener(TimerEvent.TIMER, _onTimer);
		    _timer.addEventListener(TimerEvent.TIMER_COMPLETE, _onFinishTimer);
		    
		    camera.x = camera.y = 0;
		    camera.z = -300;
		    camera.zoom = 40;

		    //stage.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
		    _timer.start();

		    startRendering();
		}

	private function _onTimer(e:TimerEvent):void {

	    camera.orbit(360*Math.random(), 360*Math.random(), true, _word);
	    Tweener.addTween(camera, {x:0,z:400*Math.random(), time:3, transition:"easeNone"}); 

	    var word:DisplayObject3D = _word.letters[textnum];
	    Tweener.addTween(word, {scale:1, x:word.extra.x, y:word.extra.y, z:word.extra.z, rotationX:0, rotationY:0, rotationZ:0, time:3, transition:"easeOutBounce"});
	    textnum++;
	}

	private function _onFinishTimer(e:TimerEvent):void {
	    _timer.removeEventListener(TimerEvent.TIMER, _onTimer);
	    _timer.removeEventListener(TimerEvent.TIMER_COMPLETE, _onFinishTimer);
	    _word.rotationY = 180;
	    camera.z = 400;
	    camera.zoom = 40;
	    camera.orbit(0.1, 0.1, true, _word);
	}
	
	//コレを追加すると何が何だか…
	private function _onEnterFrame(e:Event):void {
	    _word.rotationX += 3;
	    _word.rotationY += 4;
	    _word.rotationZ += 5;
	}
    }
}