/**
 * Copyright rfkrocktk ( http://wonderfl.net/user/rfkrocktk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gzSp
 */

// forked from rfkrocktk's Nice Matrix Rotation that works
package {
    import flash.display.GradientType;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var instance:Sprite = new Sprite();
        
        private var currentRotation:Number = 0;
        
        public function FlashTest() {
            instance.graphics.beginGradientFill(GradientType.LINEAR, [0xFF0000, 0x000000], [1,1], [0,200]);
            instance.graphics.drawRect(0, 0, 32, 32);
            
            this.addChild(instance);
            
            instance.x = (stage.stageWidth * 0.5) - (instance.width * 0.5);
            instance.y = (stage.stageHeight * 0.5) - (instance.height * 0.5);
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var matrix:Matrix = instance.transform.matrix.clone();
            
            if (currentRotation > 360) {
                currentRotation = currentRotation - 360;
            } else {
                currentRotation += 10;
            }

            var angle:Number = Math.PI * 2 * (currentRotation / 360);
            
            matrix.identity();
            
            matrix.translate(-16, -16);
            matrix.rotate(angle);
            matrix.translate(instance.x + (instance.width * 0.5),
                    instance.y + (instance.height * 0.5)); // result of original position + width * 0.5
            
            /* the problem mentioned above is that either x, y, width, and/or height seem to be changing
               on each iteration, messing everything up and preventing a  */
            
            instance.transform.matrix = matrix;
        }

    }
}