/**
 * Copyright argon ( http://wonderfl.net/user/argon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gzLn
 */

package 
{
    import flash.display.AVM1Movie;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.utils.Timer;  
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;  
    /**
     * ...
     * @author argon □□□
     */
    [SWF(backgroundColor = 0x000000, width = 465, height = 465, frameRate = 30)]
    
    public class Main extends Sprite 
    {
        private var ppt:Array;
        private var loc:Array;
        private var brightness:Number = 0;
        private var timer:Timer;
        
        private const Interval:Number = 20;
        private const Horizontal:Number = 20;
        private const Vertical:Number = 20;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            ppt = new Array();
            loc = new Array();
            
            for (var i:int = 0; i < Horizontal; i++) 
            {
                for (var j:int = 0; j < Vertical; j++) 
                {
                    var hozLoc:Number = stage.stageWidth / 2 - (Horizontal-1) * Interval / 2 + Interval * i;
                    var vartLoc:Number = stage.stageHeight / 2 - (Vertical-1) * Interval / 2 + Interval * j;
                    ppt.push(new PhysicalPoint(hozLoc, vartLoc));
                    loc.push(new Point(hozLoc, vartLoc));
                }
            }
            var glow:GlowFilter = new GlowFilter(0x9BFF9B, 1, 10, 10);
            this.filters = [glow];
            
            timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
        }
        
        private function resizeHandler(e:Event):void 
        {
            
        }
        
        private function loop(e:TimerEvent):void 
        {
            for (var i:int = 0; i < ppt.length; i++) 
            {
                ppt[i].setAccel((loc[i].x - ppt[i].x) * 10,
                                   (loc[i].y - ppt[i].y) * 10);
                var maxDist:Number = 200;
                var dist:Number = Point.distance(new Point(mouseX, mouseY), ppt[i]);
                
                if (dist < maxDist)
                {
                    var par = (maxDist - dist) / maxDist;
                    ppt[i].setAccel((mouseX - ppt[i].x) * par * 50,
                                       (mouseY - ppt[i].y ) * par * 50);
                }
            }
            graphics.clear();
            for (var j:int = 0; j < ppt.length; j++) 
            {
                graphics.moveTo(ppt[j].x, ppt[j].y);
                graphics.beginFill(0x008000, brightness);
                graphics.lineStyle(1, 0x004000, brightness);
                graphics.drawCircle(ppt[j].x, ppt[j].y,5);
                graphics.endFill();
            }
            brightness += (1 - brightness) / 100;
        }
        
    }
    
}

import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

class PhysicalPoint extends Point
{
    public var vx:Number,vy:Number;
    private var ax:Number,ay:Number;
    public var b:Number;
    public var preTime:Number;
    private var timer:Timer;
    
    public function PhysicalPoint(xx:Number=0,yy:Number=0)
    {
        x=xx,y=yy;
        vx=0,vy=0;
        ax=0,ay=0;
        b=.9;
        preTime=new Date().getTime();
        timer=new Timer(33);
        timer.addEventListener(TimerEvent.TIMER,loop);
        timer.start();
    }
    
    private function loop(e:TimerEvent):void
    {
        var nowTime:Number=new Date().getTime();
        var t:Number=(nowTime-preTime)/1000;
        x+=vx*t + .5*ax*t*t;
        y+=vy*t + .5*ay*t*t;
        vx+=ax*t;
        vy+=ay*t;
        vx*=b;
        vy*=b;
        ax=0;
        ay=0;
        preTime=nowTime;
    }
    
    public function setAccel(axx:Number=0,ayy:Number=0):void
    {
        ax+=axx;
        ay+=ayy;
    }
}

import flash.display.Sprite;

class CreateRect extends Sprite 
    {
        private var _x:Number, _y:Number;
        private var _w:Number, _h:Number;
        private var _color:uint;
        
        public function CreateRect(x:Number, y:Number, w:Number, h:Number,color:Number) 
        {
            _x = x;
            _y = y;
            _w = w;
            _h = h;
            _color = color;
            setRect();
        }
        
        private function setRect():void 
        {
            graphics.clear();
            graphics.beginFill(_color);
            graphics.drawRect(_x, _y, _w, _h);
            graphics.endFill();
        }
        
    }
