/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gzFz
 */

// bloggie http://www.amazon.co.jp/exec/obidos/ASIN/B003479I0Y/nitoyoncom-22/
// の360度パノラマ写真の中心を測定します
package{
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.system.LoaderContext;
import flash.net.*;
import com.bit101.components.*;

[SWF(backgroundColor="#ffffff")]
public class Test extends Sprite{
    private const SIZE:Number = 450;

    public function Test() {
        // load image
        var loader:Loader = new Loader();
        var context:LoaderContext = new LoaderContext(true);
        loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/9/95/9590/9590f390ef8b358e16b443d9838802d57d047fe0"), context);
        loader.contentLoaderInfo.addEventListener("complete", loadCompleteHandler);

        // start text
        var t:TextField = new TextField();
        t.text = "LOADING...";
        addChild(t);
    }

    private function loadCompleteHandler(event:Event):void {
        // copy bitmap to BitmapData
        var loaderInfo:LoaderInfo = LoaderInfo(event.target);
        var bmd:BitmapData = new BitmapData(loaderInfo.width, loaderInfo.height);
        bmd.draw(loaderInfo.loader);
        show(bmd);
    }

    private function show(bmd:BitmapData):void {
        // get size information
        var w:Number = bmd.width;
        var h:Number = bmd.height;

		var scale:Number = Math.min(SIZE / w, SIZE / h);

		var bmp:Bitmap = new Bitmap(bmd);
		addChild(bmp);
		bmp.scaleX = bmp.scaleY = scale;

		var overlay:Sprite = new Sprite();
		overlay.scaleX = overlay.scaleY = scale;
		addChild(overlay);

		var centerX:Number = w / 2;
		var centerY:Number = h / 2;
		var r1:Number = 50, r2:Number = 200;

		var yy:int = h * scale;
		var xSlider:HUISlider = new HUISlider(this, 0, yy += 16, "Center X", function(event:Event):void {
			centerX = w / 2 + xSlider.value;
			drawOverlay();
		});
		xSlider.width = SIZE;
		xSlider.minimum = -w / 2;
		xSlider.maximum = w / 2;

		var ySlider:HUISlider = new HUISlider(this, 0, yy += 16, "Center Y", function(event:Event):void {
			centerY = h / 2 + ySlider.value;
			drawOverlay();
		});
		ySlider.width = SIZE;
		ySlider.minimum = -h / 2;
		ySlider.maximum = h / 2;

		var r1Slider:HUISlider = new HUISlider(this, 0, yy += 16, "R1", function(event:Event):void {
			r1 = r1Slider.value;
			drawOverlay();
		});
		r1Slider.width = SIZE;
		r1Slider.minimum = 0;
		r1Slider.maximum = h / 2;
		r1Slider.value = r1;

		var r2Slider:HUISlider = new HUISlider(this, 0, yy += 16, "R2", function(event:Event):void {
			r2 = r2Slider.value;
			drawOverlay();
		});
		r2Slider.width = SIZE;
		r2Slider.minimum = 0;
		r2Slider.maximum = h / 2;
		r2Slider.value = r2;

		drawOverlay();

		function drawOverlay():void {
			overlay.graphics.clear();
			overlay.graphics.lineStyle(0, 0xff0000);
			overlay.graphics.moveTo(centerX - 10, centerY - 10);
			overlay.graphics.lineTo(centerX + 10, centerY + 10);
			overlay.graphics.moveTo(centerX - 10, centerY + 10);
			overlay.graphics.lineTo(centerX + 10, centerY - 10);
			overlay.graphics.drawCircle(centerX, centerY, r1);
			overlay.graphics.drawCircle(centerX, centerY, r2);
		}
    }
}
}
