/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gz5w
 */

// HyperbolicFunction(双曲線関数) のグラフ
// 赤･･･sinh(x) 緑･･･cosh(x)　青･･･tanh(x)
// 複素平面などで3次元曲面を描く時に使用
// 詳細はwikiで！

package
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.Point;

	public class HyFunc extends Sprite
	{
		public function HyFunc()
		{
			this.graphics.lineStyle(1,0x00);
			this.graphics.moveTo(0,233);
			this.graphics.lineTo(465,233);
			this.graphics.moveTo(233,0);
			this.graphics.lineTo(233,465);
			this.graphics.endFill();
			
			var P:uint = 25;
			var step:Number=0.1;
			var line:Shape = addChild(new Shape())as Shape;
			line.x = line.y = 233;
			line.scaleY = -1;
			
			var po:Object = {s:hyF.sihH(-10),c:hyF.cosH(-10),t:hyF.tanH(-10)};
			
			for(var i:Number=-10; i<10; i+=step)
			{
				var s:Number = hyF.sihH(i);
				line.graphics.lineStyle(1,0xff0000);
				line.graphics.moveTo((i-step)*P,po.s*P);
				line.graphics.lineTo(i*P,s*P);
				line.graphics.endFill();
				po.s = s;
				
				var c:Number = hyF.cosH(i);
				line.graphics.lineStyle(1,0x00ff00);
				line.graphics.moveTo((i-step)*P,po.c*P);
				line.graphics.lineTo(i*P,c*P);
				line.graphics.endFill();
				po.c = c;
				
				var t:Number = hyF.tanH(i);
				line.graphics.lineStyle(1,0x0000ff);
				line.graphics.moveTo((i-step)*P,po.t*P);
				line.graphics.lineTo(i*P,t*P);
				line.graphics.endFill();
				po.t = t;
			}
		}
	}
}

class hyF
{
	public function hyF(){}
	
	public static function sihH(num:Number):Number
	{
		return (Math.exp(num)-Math.exp(-num))/2;
	}
	
	public static function cosH(num:Number):Number
	{
		return (Math.exp(num)+Math.exp(-num))/2;
	}
	
	public static function tanH(num:Number):Number
	{  
		return hyF.sihH(num)/hyF.cosH(num);
	}  
}
