/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gyPP
 */

// forked from kotobuki's Gainer Basic Example: LED
// 画面上のボタンを押すとI/Oモジュール上のLEDが点灯し、
// ボタンを離すとI/Oモジュール上のLEDが消灯します。
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {
        private var gio:Gainer;

        private var squareButton:Sprite;

        public function GainerBasic_LED() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;

            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            gio.led.on();
            squareButton.scaleX = 1.2;
            squareButton.scaleY = 1.2;
        }

        private function mouseReleased(e:MouseEvent):void {
            gio.led.off();
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
