/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gyGq
 */

// forked from siouxcitizen's 3DPlaneにプログラム描画の画像貼りつけ練習
//
//前回ソースから散るサクラっぽいの目指してみましたがイマイチ。。。
//
//以下コードとサイトを参考にさせていただきました。
//[PV3D] パーティクルモーション
//http://wonderfl.net/c/7UrP/read
//
//SAKURA
//http://wonderfl.net/c/mHNT/read
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.filters.GlowFilter;

    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#66CCFF")]
 
    public class MoviePlane extends Sprite
    {
        private var container : Sprite;
        private var viewport  : Viewport3D;
        private var scene     : Scene3D;
        private var camera    : Camera3D;
        private var material  : BitmapMaterial;
        private var planeObj  : Plane; 
        private var renderer  : BasicRenderEngine;

        private var pixelArr        :Array  = [];     // パーティクルを格納する配列
        private const PIXEL_NUM : int = 5;     // 縦・横のピクセル数
        private const PLANE_SIZE : int = 90;//Planeオブジェクト1辺の長さ
        private const PLANE_SEGMENT   : int = 1;  //面の分割数
        private const PLANE_MARGIN  :int    = 30;     // パーティクルの余白
        private var tempPlaneName : String = "";

        private var filterList : Array;
        //MoviePlaneクラスのコンストラクタ
        public function MoviePlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x333333;

            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //テクスチャ用画像を作成
            var recipe:Recipe = new Recipe();
            recipe.width = 16;
            recipe.height = 16;
            recipe.scale = 10.0;
            recipe.data = [0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,
                           0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,2,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,2,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,2,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,3,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,
                           0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
                           0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0];
            recipe.pallet.push(0xFFff0000, 0xFFff99ff, 0xFFffaaff, 0xFFffbbff);
            recipe.transparent = 0;
            var textureOnPlane : DotDraw = new DotDraw(recipe);

            //bitmapDataを用意する
            var bitmapData:BitmapData = new BitmapData(320, 320, true, 0x00000000); // 透明なBitmapDataを用意
            var matrix:Matrix = new Matrix();   // 表示位置はMatrixで指定する
            matrix.translate(0, 0);   // (0, 0)の位置に描画する設定にする
            bitmapData.draw(textureOnPlane, matrix);    // spriteをbitmapDataに描画する

            //フィルターの準備
            filterList = new Array();
            var glowFilter : GlowFilter = new GlowFilter(0xFFFFFF, 1, 32, 32, 2, 1, false, false); 
            filterList.push(glowFilter);

            //マテリアル設定
            material = new BitmapMaterial(bitmapData, false);
            material.doubleSided = true;

            pixelArr = [];
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                pixelArr[i] = [];
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    // Planeインスタンスを作成
                    var o:Plane = new Plane(material, PLANE_SIZE, PLANE_SIZE, PLANE_SEGMENT, PLANE_SEGMENT);
                    o.useOwnContainer = true; //フィルター使用のために設定
                    o.filters = filterList; //フィルター使用のために設定
                    scene.addChild(o);
                    pixelArr[i][j] = o;
                    
                    // 座標
                    o.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    o.y = Math.random()*5000;
                    o.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                }
            }

            //カメラ設定
            camera = new Camera3D();
            camera.x = PLANE_SIZE * (PIXEL_NUM / 2);
            camera.y = 1000;
            camera.z = -PLANE_SIZE;
            camera.focus = 50;
            camera.zoom = 1;
 
            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, _enterframe);
        }

        //マウスイベント処理
        private function _enterframe(e:Event):void{
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    var p:DisplayObject3D = pixelArr[i][j];
                    if (p.y > 0) {
                        p.rotationX += Math.random() * 10; 
                        p.rotationY += Math.random() * 10;
                        //p.y -= 10;
                        //p.y -= Math.random() * 10; 
                        p.y -= (Math.random() * 20 + 1) - (180 - (p.rotationX % 180)) * .008;
                    } else {
                        p.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                        p.y = Math.random()*5000;
                        p.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    }
                }
            }
            renderer.renderScene(scene, camera, viewport);
        }
    }
}

class Recipe {
    public var width:uint = 0;
    public var height:uint = 0;
    public var scale:Number = 1.0;
    public var data:/*uint*/Array = new Array();
    public var pallet:/*uint*/Array = new Array();
    public var transparent:int = -1;
}

import flash.display.Sprite;
class DotDraw extends Sprite {
    public function DotDraw(recipe:Recipe) {
        for (var index:uint = 0; index < recipe.width * recipe.height; ++index) {
            var x:uint = index % recipe.width;
            var y:uint = uint(index / recipe.width);
            
            var datum:uint = recipe.data[x + (y * recipe.width)];
            var color:uint = recipe.pallet[datum];
            var scale:Number = recipe.scale;
            var alpha:Number = (datum == recipe.transparent) ? 0.0 : 1.0;
            
            this.graphics.beginFill(color, alpha);
            this.graphics.drawRect(x * scale, y * scale, scale, scale);
            this.graphics.endFill();
        }
    }

}