/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gxfV
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
        }
    }
}
import flash.utils.getTimer;



 class Std {
        static public function _is(v : *,t : *) : Boolean {
            try {
                if(t == Object) return true;
                return v is t;
            }
            catch( e : * ){
            };
            return false;
        }
        
        static public function instance(value : *,c : Class) : * {
            return value as c;
        }
        
        static public function string(s : *) : String {
            return ""+s;
        }
        
        static public function _int(x : Number) : int {
            return int(x);
        }
        
        static public function _parseInt(x : String) : * {
            var v : * = parseInt(x);
            if(isNaN(v)) return null;
            return v;
        }
        
        static public function _parseFloat(x : String) : Number {
            return parseFloat(x);
        }
        
        static public function random(x : int) : int {
            if(x <= 0) return 0;
            else return Math.floor(Math.random() * x);
            return 0;
        }
        
    }


     class enum {
        public var tag : String;
        public var index : int;
        public var params : Array;
        public function toString() : String { return enum_to_string(this); }
        static protected var IN_E : int = 0;
        static public function enum_to_string(e : *) : String {
            if(e.params == null) return e.tag;
            var pstr : Array = [];
            if(IN_E > 15) pstr.push("...");
            else {
                IN_E++;
                {
                    var _g : int = 0;
                    var _g1 : Array = e.params;
                    while(_g < _g1.length) {
                        var p : * = _g1[_g];
                        ++_g;
                        pstr.push(""+p);
                    }
                };
                IN_E--;
            };
            return e.tag + "(" + pstr.join(",") + ")";
        }
    }
    
    



     final class BGTrainState extends enum {
        public static const __isenum : Boolean = true;
        public function BGTrainState( t : String, index : int, p : Array = null ) : void { this.tag = t; this.index = index; this.params = p; }
        public static function ACCEL(wontSpeed : Boolean) : BGTrainState { return new BGTrainState("ACCEL",1,[wontSpeed]); }
        public static function BRAKING(wontSpeed : Boolean) : BGTrainState { return new BGTrainState("BRAKING",3,[wontSpeed]); }
        public static var SPEEDING : BGTrainState = new BGTrainState("SPEEDING",2);
        public static var STOPPED : BGTrainState = new BGTrainState("STOPPED",0);
        public static var __constructs__ : Array = ["STOPPED","ACCEL","SPEEDING","BRAKING"];
    }



interface IBGTrain {
        function get_currentPosition() : Number ;
        function get_targetDest() : Number ;
        function resetTo(index : int) : void ;
        function travelTo(index : int) : void ;
        function stopAt(index : int) : void ;
        function missStopAt(index : int) : void ;
        function setMaxSpeed(maxSpeed : Number) : void ;
        function setPickupTimespans(accelSpan : Number,brakeSpan : Number) : void ;
        function setupEasingFunctions(powerIndex : int) : void ;
        function update() : void ;
        function setCruisingSpeed(speed : Number) : void ;

    }


     class SceneModel implements IBGTrain{
        public function SceneModel() : void {
            this.calcPickupTime();
            this.setPickupTimespans(3,3);
        }
        
        protected var _curLoc : Number = 0;
        protected var _targetDest : Number = 0;
        public function get targetDest() : Number { return get_targetDest(); }
        public function set targetDest( __v : Number ) : void { $targetDest = __v; }
        protected var $targetDest : Number;
        public function get_targetDest() : Number {
            return this._targetDest;
        }
        
        protected var _reseting : Boolean = true;
        protected var _cruisingSpeed : Number = 1;
        protected var _maxSpeed : Number = 3;
        protected var _isStarted : Boolean = false;
        protected var _startIndex : Number = -1;
        protected var _tweenProgress : Number = 0;
        protected var _tweenDuration : Number = 0;
        protected var _pickupTime : Number;
        protected var _pickupTimeDiff : Number;
        protected var _pickupTimeDistCovered : Number;
        protected function calcPickupTime() : void {
            this._pickupTime = (this.easeFuncs.deriativeGetX)(this._maxSpeed);
            this._pickupTimeDistCovered = (this.easeFuncs.distCovered)(this._pickupTime);
            this._pickupTimeDiff = this._pickupTime - this._pickupTimeDistCovered / this._maxSpeed;
        }
        
        public var easeFuncs : EaseFunctions = EaseFunctions.create(2);
        public function setupEasingFunctions(powerIndex : int) : void {
            this.easeFuncs = EaseFunctions.create(powerIndex);
            this.calcPickupTime();
        }
        
        protected var pickupTimeSpan : Number = 1;
        protected var pickdownTimeSpan : Number = 1;
        protected var pickupAndDownMidpointRatio : Number = .5;
        public function setPickupTimespans(accelSpan : Number,brakeSpan : Number) : void {
            this.pickupTimeSpan = accelSpan;
            this.pickdownTimeSpan = brakeSpan;
            this.pickupAndDownMidpointRatio = this.pickupTimeSpan / (this.pickupTimeSpan + this.pickdownTimeSpan);
        }
        
        protected function get pickupUnitTimeLength() : Number { return get_pickupUnitTimeLength(); }
        protected function set pickupUnitTimeLength( __v : Number ) : void { $pickupUnitTimeLength = __v; }
        protected var $pickupUnitTimeLength : Number;
        public function get_pickupUnitTimeLength() : Number {
            return this.pickupTimeSpan * 60;
        }
        
        protected function get pickdownUnitTimeLength() : Number { return get_pickdownUnitTimeLength(); }
        protected function set pickdownUnitTimeLength( __v : Number ) : void { $pickdownUnitTimeLength = __v; }
        protected var $pickdownUnitTimeLength : Number;
        public function get_pickdownUnitTimeLength() : Number {
            return this.pickdownTimeSpan * 60;
        }
        
        protected function get pickupTimeDur() : Number { return get_pickupTimeDur(); }
        protected function set pickupTimeDur( __v : Number ) : void { $pickupTimeDur = __v; }
        protected var $pickupTimeDur : Number;
        public function get_pickupTimeDur() : Number {
            return this._pickupTime * 60 * this.pickupTimeSpan;
        }
        
        protected function get pickdownTimeDur() : Number { return get_pickdownTimeDur(); }
        protected function set pickdownTimeDur( __v : Number ) : void { $pickdownTimeDur = __v; }
        protected var $pickdownTimeDur : Number;
        public function get_pickdownTimeDur() : Number {
            return this._pickupTime * 60 * this.pickdownTimeSpan;
        }
        
        protected function get totalPickupAndDownTimeDur() : Number { return get_totalPickupAndDownTimeDur(); }
        protected function set totalPickupAndDownTimeDur( __v : Number ) : void { $totalPickupAndDownTimeDur = __v; }
        protected var $totalPickupAndDownTimeDur : Number;
        public function get_totalPickupAndDownTimeDur() : Number {
            return this.get_pickupTimeDur() + this.get_pickdownTimeDur();
        }
        
        public function isBlendAccelBrake() : Boolean {
            return this._pickupTimeDistCovered * this.pickupTimeSpan + this._pickupTimeDistCovered * this.pickdownTimeSpan >= this._targetDest - this._startIndex;
        }
        
        public function isBlendAccelBrake2() : Boolean {
            return this.get_totalPickupAndDownTimeDur() >= this._tweenDuration;
        }
        
        public function resetTo(index : int) : void {
            this._reseting = true;
            this._targetDest = index;
        }
        
        protected var _forceStop : Boolean = false;
        public function get currentPosition() : Number { return get_currentPosition(); }
        public function set currentPosition( __v : Number ) : void { $currentPosition = __v; }
        protected var $currentPosition : Number;
        public function get_currentPosition() : Number {
            return this._curLoc;
        }
        
        protected var _startTime : Number = -1;
        public function travelTo(index : int) : void {
            if(!this._isStarted) {
                this._targetDest = index;
                this._isStarted = true;
                var tarIndex : Number = Std._int(this._curLoc);
                this._startTime = getTimer() / 1000;
                this._startIndex = tarIndex;
                this._tweenProgress = 0;
                this._tweenDuration = (index - this._startIndex) * 60 / this._maxSpeed + this._pickupTimeDiff * this.pickupTimeSpan * 60 + this._pickupTimeDiff * this.pickdownTimeSpan * 60;
            }
            else {
                if(this._braking) {
                    var tarLoc : Number = this._tweenProgress - this._tweenDuration + this.get_pickdownUnitTimeLength();
                    var xRatio : Number = tarLoc /= this.get_pickdownUnitTimeLength();
                    tarLoc = (this.easeFuncs.distCovered_Out)(tarLoc);
                    tarLoc *= this.pickdownTimeSpan;
                    tarLoc += this._targetDest - this.pickdownTimeSpan;
                    this._curLoc = tarLoc;
                    xRatio = 1 - xRatio;
                    var tarIndex1 : Number = tarLoc -= (this.easeFuncs.distCovered)(xRatio) * this.pickupTimeSpan;
                    this._startIndex = tarLoc;
                    this._tweenProgress = xRatio * this.get_pickupUnitTimeLength();
                    this._startTime = getTimer()/1000 - this._tweenProgress / 60;
                    this._targetDest = index;
                }
                else {
                    this._targetDest = index;
                    
                };
                this._tweenDuration = (index - this._startIndex) * 60 / this._maxSpeed + this._pickupTimeDiff * this.pickupTimeSpan * 60 + this._pickupTimeDiff * this.pickdownTimeSpan * 60;
            };
            if(this.isBlendAccelBrake()) {
                var y : Number = this._targetDest - this._startIndex;
                this._tweenDuration = (this.easeFuncs.distCoveredGetX)(y / this.pickupTimeSpan * this.pickupAndDownMidpointRatio) * 60 * this.pickupTimeSpan + (this.easeFuncs.distCoveredGetX)(y / this.pickdownTimeSpan * (1 - this.pickupAndDownMidpointRatio)) * 60 * this.pickdownTimeSpan;
            }
        }
        
        public function stopAt(index : int) : void {
            this._targetDest = index;
        }
        
        public function missStopAt(index : int) : void {
            if(this._curLoc <= index + .75) this._targetDest = index + .75;
            else this._targetDest = index;
        }
        
        public function setMaxSpeed(maxSpeed : Number) : void {
            this._maxSpeed = maxSpeed;
            this.calcPickupTime();
        }
        
        public function setCruisingSpeed(speed : Number) : void {
            this._cruisingSpeed = speed;
        }
        
        public var movingState : BGTrainState = BGTrainState.STOPPED;
        protected var _braking : Boolean = true;
        public function update() : void {
            if(this._isStarted) {
                this._tweenProgress = (getTimer()/1000 - this._startTime) * 60;
                if(this._tweenProgress > this._tweenDuration) this._tweenProgress = this._tweenDuration;
                this._braking = false;
                var tarLoc : Number = 0;
                var exceed : Boolean = this.isBlendAccelBrake();
                var exceed2 : Boolean = this.isBlendAccelBrake2();
                
                var exceedBreaking : Boolean = false;
                if(exceed) exceedBreaking = this._tweenProgress >= this._tweenDuration * this.pickupAndDownMidpointRatio;
                if(exceed && !exceedBreaking || !exceed && this._tweenProgress < this.get_pickupTimeDur()) {
                
                    tarLoc = this._tweenProgress / this.get_pickupUnitTimeLength();
                    tarLoc = (this.easeFuncs.distCovered)(tarLoc);
                    tarLoc *= this.pickupTimeSpan;
                    tarLoc += this._startIndex;
                    this.movingState = BGTrainState.ACCEL(exceed);
                }
                else if(exceed && exceedBreaking || !exceed && this._tweenProgress >= this._tweenDuration - this.get_pickdownTimeDur()) {
                    this._braking = true;
                    tarLoc = this._tweenProgress - this._tweenDuration + this.get_pickdownUnitTimeLength();
                    tarLoc /= this.get_pickdownUnitTimeLength();
                
                    tarLoc = (this.easeFuncs.distCovered_Out)(tarLoc);
                    tarLoc *= this.pickdownTimeSpan;
                    tarLoc += this._targetDest - this.pickdownTimeSpan;
                    this.movingState = BGTrainState.BRAKING(exceed);
                }
                else if(!exceed) {
                    tarLoc = CSMath.lerp(this._startIndex + this._pickupTimeDistCovered * this.pickupTimeSpan,this._targetDest - this._pickupTimeDistCovered * this.pickdownTimeSpan,(this._tweenProgress - this.get_pickupTimeDur()) / (this._tweenDuration - this.get_totalPickupAndDownTimeDur()));
                    this.movingState = BGTrainState.SPEEDING;
                }
                this._curLoc = tarLoc;
                if(this._tweenProgress >= this._tweenDuration) {
                    this._tweenProgress = this._tweenDuration;
                    this._isStarted = false;
                }
            }
            else this.movingState = BGTrainState.STOPPED;
            if(this._forceStop) {
                this._forceStop = false;
                this._isStarted = false;
                this.movingState = BGTrainState.STOPPED;
            }
        }
        
        static protected var PUSH_FORWARD_ERROR : Number = .75;
        static public function main() : void {
        }
        
        static protected var unitTimeLength : Number = 60;
    }


class CSMath {
        static public function lerp(n0 : Number,n1 : Number,p : Number) : Number {
            return n0 * (1 - p) + n1 * p;
        }
        
        static public function rnd(min : Number,max : Number) : Number {
            return min + Math.random() * (max - min);
        }
        
    }



class EaseFunctions {
        public function EaseFunctions() : void {
        }
        
        public var distCovered : Function;
        public var distCovered_Out : Function;
        public var distCoveredGetX : Function;
        public var deriative : Function;
        public var deriativeGetX : Function;
        static public function linearDistCovered(t : Number) : Number {
            return t;
        }
        
        static public function linearDistCoveredGetX(offset : Number) : Number {
            return offset;
        }
        
        static public function linearDeriative(x : Number) : Number {
            return 1;
        }
        
        static public function linearDeriativeGetX(v : Number) : Number {
            return 0;
        }
        
        static public function quadraticDistCovered(t : Number) : Number {
            return t * t;
        }
        
        static public function quadraticDistCovered_Out(t : Number) : Number {
            return t * (2 - t);
        }
        
        static public function quadraticDistCoveredGetX(offset : Number) : Number {
            return Math.sqrt(offset);
        }
        
        static public function quadraticDeriative(x : Number) : Number {
            return 2 * x;
        }
        
        static public function quadraticDeriativeGetX(v : Number) : Number {
            return v / 2;
        }
        
        static public function cubicDistCovered(t : Number) : Number {
            return t * t * t;
        }
        
        static public function cubicDistCovered_Out(t : Number) : Number {
            return --t * t * t + 1;
        }
        
        static public function cubicDistCoveredGetX(offset : Number) : Number {
            return Math.pow(offset,0.33333333333333331);
        }
        
        static public function cubicDeriative(x : Number) : Number {
            return 3 * x * x;
        }
        
        static public function cubicDeriativeGetX(v : Number) : Number {
            return Math.sqrt(v / 3);
        }
        
        static public function quarticDistCovered(t : Number) : Number {
            return t * t * t * t;
        }
        
        static public function quarticDistCovered_Out(t : Number) : Number {
            return 1 - --t * t * t * t;
        }
        
        static public function quarticDistCoveredGetX(offset : Number) : Number {
            return Math.pow(offset,0.25);
        }
        
        static public function quarticDeriative(x : Number) : Number {
            return 4 * x * x * x;
        }
        
        static public function quarticDeriativeGetX(v : Number) : Number {
            return Math.pow(v / 4,0.33333333333333331);
        }
        
        static public function quinticDistCovered(t : Number) : Number {
            return t * t * t * t * t;
        }
        
        static public function quinticDistCovered_Out(t : Number) : Number {
            return 1 + --t * t * t * t * t;
        }
        
        static public function quinticDistCoveredGetX(offset : Number) : Number {
            return Math.pow(offset,0.2);
        }
        
        static public function quinticDeriative(x : Number) : Number {
            return 5 * x * x * x * x;
        }
        
        static public function quinticDeriativeGetX(v : Number) : Number {
            return Math.pow(v / 5,0.25);
        }
        
        static public var LINEAR : int = 0;
        static public var QUADRATIC : int = 1;
        static public var CUBIC : int = 2;
        static public var QUARTIC : int = 3;
        static public var QUINTIC : int = 4;
        static public function create(powerIndex : int) : EaseFunctions {
            var me : EaseFunctions = new EaseFunctions();
            switch(powerIndex) {
            case 0:
            {
                me.distCovered = EaseFunctions.linearDistCovered;
                me.distCovered_Out = EaseFunctions.linearDistCovered;
                me.distCoveredGetX = EaseFunctions.linearDistCoveredGetX;
                me.deriative = EaseFunctions.linearDeriative;
                me.deriativeGetX = EaseFunctions.linearDeriativeGetX;
            }
            break;
            case 1:
            {
                me.distCovered = EaseFunctions.quadraticDistCovered;
                me.distCovered_Out = EaseFunctions.quadraticDistCovered_Out;
                me.distCoveredGetX = EaseFunctions.quadraticDistCoveredGetX;
                me.deriative = EaseFunctions.quadraticDeriative;
                me.deriativeGetX = EaseFunctions.quadraticDeriativeGetX;
            }
            break;
            case 2:
            {
                me.distCovered = EaseFunctions.cubicDistCovered;
                me.distCovered_Out = EaseFunctions.cubicDistCovered_Out;
                me.distCoveredGetX = EaseFunctions.cubicDistCoveredGetX;
                me.deriative = EaseFunctions.cubicDeriative;
                me.deriativeGetX = EaseFunctions.cubicDeriativeGetX;
            }
            break;
            case 3:
            {
                me.distCovered = EaseFunctions.quarticDistCovered;
                me.distCovered_Out = EaseFunctions.quarticDistCovered_Out;
                me.distCoveredGetX = EaseFunctions.quarticDistCoveredGetX;
                me.deriative = EaseFunctions.quarticDeriative;
                me.deriativeGetX = EaseFunctions.quarticDeriativeGetX;
            }
            break;
            case 4:
            {
                me.distCovered = EaseFunctions.quinticDistCovered;
                me.distCovered_Out = EaseFunctions.quinticDistCovered_Out;
                me.distCoveredGetX = EaseFunctions.quinticDistCoveredGetX;
                me.deriative = EaseFunctions.quinticDeriative;
                me.deriativeGetX = EaseFunctions.quinticDeriativeGetX;
            }
            break;
            default:
            
            break
            };
            return me;
        }
        
    }

