/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gx6V
 */

package
{
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.events.Event; 
    import net.wonderfl.utils.SequentialLoader;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    public class Main extends BasicView
    {
        private const imgURL:String="http://assets.wonderfl.net/images/related_images/a/ae/ae23/ae2348f021fd98d3c8b64fe6eb1769fec2dd1ed8";
        private var plane:Plane;
        private var theta:Number;
        private var imgs:Array;
        
        public function Main()
        {
            super(0, 0, true, true);
            theta = 0;
            imgs = [];

            SequentialLoader.loadImages([imgURL], imgs, onLoaded);
        }
        
        private function onLoaded():void
        {
            var ldr:Loader=imgs.pop();
            var mat:BitmapMaterial = new BitmapMaterial((ldr.content as Bitmap).bitmapData, true);
            mat.doubleSided = true;
            plane = scene.addChild(new Plane(mat, 700, 700, 15, 15)) as Plane;
            
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onFrame(e:Event):void
        {
            var s:int=0;
            var c:int=0;
            
            // 頂点を制御して、サインカーブを適用
            for each (var obj:Vertex3D in plane.geometry.vertices)
            {
                obj.z=80 * Math.sin((theta + s) * Math.PI / 180);
                c++;
                if (c % 15 == 0) s+=20;
            }
            
            theta+=15;
            plane.rotationX+=0.5;
            plane.rotationY+=0.5;
            singleRender();        
        }
    }
}