/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gwO2
 */

//重いよ 右下がぺこぺこなるのは仕様
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.shaders.EnvMapShader;
    import org.papervision3d.materials.shaders.ShadedMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    [SWF(backgroundColor="#000010", frameRate="60",width="465",height="465" )]
    public class Main extends BasicView
    {
        private const MAX:int = 30 ;
        
        private var _pp:Vector.<Number> = new Vector.<Number> ( MAX * MAX ) ;
        private var _pv:Vector.<Number> = new Vector.<Number> ( MAX * MAX ) ;
        private var _p:Plane;
        
        private var _PL:PointLight3D;
        private var _ES:EnvMapShader;
        private var _SM:ShadedMaterial;
        
        private var _light:BitmapData;
        private var _texture:BitmapData;
        private var _bump:BitmapData;
        private var _offset:Array;
        
        public function Main ( ) :void {
            
            //作業用
            var S:Sprite = new Sprite;
            var G:Graphics = S.graphics ;
            var MAT:Matrix = new Matrix ;
            
            //バンプ用テクスチャ
            _bump  = new BitmapData ( 200 , 200 , false, 0 ) ;
            _offset = new Array ;
            _offset.push ( new Point ) ;
            _offset.push ( new Point ) ;
            _offset.push ( new Point ) ;
            
            //ライト用テクスチャ
            _light = new BitmapData ( 200 , 200 , true , 0 ) ;
            MAT.createGradientBox ( 300 , 300 , 0 , -120 , -120 ) ;
            G.beginGradientFill ( "radial" , [ 0xFFFFFF , 0 ] , [ 1 , 0 ] , [ 0 , 255 ] , MAT ) ;
            G.drawRect ( 0 , 0 , 200 , 200 ) ;
            G.endFill ( ) ;
            _light.draw ( S ) ;
            
            //水面用テクスチャ
            _texture = new BitmapData ( 200 , 200 , true , 0 ) ;
            MAT.createGradientBox ( 200 , 200 , 0 , 0 , 0 ) ;
            G.clear();
            G.beginGradientFill ( "radial" , [ 0xFFFFFF , 0 ] , [ 1 , 0 ] , [ 0 , 255 ] , MAT ) ;
            G.drawRect ( 0 , 0 , 200 , 200 ) ;
            G.endFill ( ) ;
            _texture.draw ( S ) ;
            //_texture.perlinNoise ( 200 , 200 , 5 , 0 , true , true , 4 ) ;
            //_texture.applyFilter ( _texture , _texture.rect , new Point , new ColorMatrixFilter ( [ 1 , .6 , .6 , 0 , .7 , .6 , 1 , .6 , 0 , .7 , .6 , .6 , 1 , 0 , .7 , 0 , 0 , 0 , .4 , 0 ] ) ) ;
            
            //水底用テクスチャ
            //var TTEX:BitmapData = new BitmapData ( 200 , 200 , false , 0x242533 ) ;
            
            //ライト生成
            _PL = new PointLight3D ;
            _PL.x = _PL.y = _PL.z = 200 ;
            
            //3D水面生成 スペキュラ利かないらしい。
            _ES = new EnvMapShader ( _PL , _light , _light , 0 , _bump , null ) ;
            _SM = new ShadedMaterial ( new BitmapMaterial ( _texture ) , _ES , 0 ) ;
            _p = new Plane ( _SM , 100 , 100 , MAX - 1 , MAX - 1 ) ;
            _p.rotationX = 90 ;
            scene.addChild( _p );
            
            //3D水底生成
            //var p:Plane = new Plane ( new BitmapMaterial ( TTEX ) , 100 , 100 , 4 , 4 ) ;
            //p.rotationX = 90 ;
            //p.y = -20;
            //scene.addChild ( p ) ;
            
            
            //カメラセット
            camera.x = -200 ;
            camera.y = 200 ;
            camera.z = - 50 ;
            camera.focus = 30 ;
            camera.lookAt ( _p ) ;
            
            startRendering ( ) ;
            
            addEventListener ( Event.ENTER_FRAME , RUN ) ;

        }

        public function RUN ( e:Event ) :void {
            
            //汎用
            var x:int = 0 ;
            var y:int = 0 ;
            var I:int = 0 ;
            var U:int = 0 ;
            var D:int = 0 ;
            var L:int = 0 ;
            var R:int = 0 ;
            
            
            //バンプマップアニメーション
            _offset[0].y += .1 ;
            _offset[1].y += .2 ;
            _offset[2].y += .3 ;
            _bump.perlinNoise ( 10 , 10 , 3 , 0 , true , true , 15 , false , _offset ) ;
            
            //指定しなおさないとアニメーションしてくれないっぽい。
            _ES.bumpmap = _bump;
            
            
            //適当に水面を揺らす
            var temp:int = 4 * MAX + 4 ;
            _pv[ temp ] = 0 ;
            _pp[ temp ] = Math.random() * 20 ;
            
            //周囲の水面の平均の高さと比較して速度を求める
            for ( x = 1 ; x < MAX - 1 ; ++ x ) {
                
                for ( y = 1 ; y < MAX - 1 ; ++ y ) {
                    
                    I = x * MAX + y ;
                    U = I - MAX ;
                    D = I + MAX ;
                    L = I -  1 ;
                    R = I +  1 ;
                    
                    var N:Number = ( _pp[U] + _pp[D] + _pp[L] + _pp[R] + _pp[I] ) * .2 ;
                    
                    _pv[I] += ( N - _pp[I] ) * .8 ;
                    _pv[I] *= .99 ;
                    
                }
                
            }
            
            //水面を揺らす
            for ( x = 1 ; x < MAX - 1 ; ++ x ) {
                
                for ( y = 1 ; y < MAX - 1 ; ++ y ) {
                    
                    I = x * MAX + y ;
                    _pp[I] += _pv[I] ;
                    
                }
            }
            
            //3Dオブジェクトを更新
            var c:int = 0 ;
            for each ( var v1:Vertex3D in _p.geometry.vertices ) {
                v1.z = _pp[ c ] ;
                c ++ ;
            }
            
            
            //法線の再計算
            for each ( var t:Triangle3D in _p.geometry.faces ) {
                t.createNormal ( ) ;
            }
            
            //法線の再計算
            for each ( var v2:Vertex3D in _p.geometry.vertices ) {
                v2.calculateNormal ( ) ;
            }
                
            
        }

    }
    
}