/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gvuh
 */

// forked from ProjectNya's TextEffect
////////////////////////////////////////////////////////////////////////////////
// TextEffect
//
// [AS3.0] 集まって整列する文字
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1604
// [AS3.0] FontLoaderクラスに挑戦！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1337
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.text.Font;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var progressBar:ProgressBar;
        private var provider:FontLoader;
        private var loader:FontLoader;
        //private static var basePath:String = "";
        private static var basePath:String = "http://www.project-nya.jp/images/flash/";
        private static var basicPath:String = "fonts/MyriadProSemibold.swf";
        private static var fontPath:String = "fonts/MPlus2PBold.swf";
        private static var basicName:String = "MyriadProSemibold";
        private static var className:String = "MPlus2PBold";
        private var container:Sprite;
        private var lists:Array;
        private var orders:Array;
        private var txts:Array;
        private static var glow:GlowFilter;
        private static var mwidth:uint = 10;
        private static var mheight:uint = 40;
        private var playBtn:Btn;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            glow = new GlowFilter(0x3399CC, 1, 12, 12, 4, 3, false, false);
            //
            container = new Sprite();
            addChild(container);
            //
            lists = new Array();
            lists.push("SSNの皆さん!|こんにちは。");
            lists.push("ssn12番のあき爺です。");
            lists.push("今年もよろしくおねがいします。");
            //
            provider = new FontLoader();
            provider.addEventListener(FontLoader.COMPLETE, provided, false, 0, true);
            provider.load(basePath + basicPath, basicName);
        }
        private function provided(evt:Event):void {
            provider.removeEventListener(FontLoader.COMPLETE, provided);
            //
            progressBar = new ProgressBar(464);
            addChild(progressBar);
            progressBar.x = 232;
            progressBar.y = 212;
            progressBar.addEventListener(ProgressBar.FADE_OUT, fadeOut, false, 0, true);
            progressBar.addEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut, false, 0, true);
            progressBar.init();
            //
            loader = new FontLoader();
            loader.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
            loader.addEventListener(FontLoader.COMPLETE, loaded, false, 0, true);
            loader.load(basePath + fontPath, className);
        }
        private function progress(evt:ProgressEvent):void {
            progressBar.progress(evt.bytesLoaded, evt.bytesTotal);
        }
        private function loaded(evt:Event):void {
            loader.removeEventListener(FontLoader.COMPLETE, loaded);
            var className:String = loader.className;
            var font:Font = loader.font;
            initialize();
            setup();
            reset();
            //
            playBtn = new Btn();
            addChild(playBtn);
            playBtn.x = 232;
            playBtn.y = 445;
            playBtn.init({label: "play", type: 2});
            playBtn.addEventListener(MouseEvent.CLICK, play, false, 0, true);
            playBtn.enabled = false;
        }
        private function fadeOut(evt:Event):void {
            progressBar.removeEventListener(ProgressBar.FADE_OUT, fadeOut);
        }
        private function barFadeOut(evt:Event):void {
            progressBar.removeEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut);
            playBtn.enabled = true;
            removeChild(progressBar);
            progressBar = null;
        }
        private function play(evt:MouseEvent):void {
            playBtn.selected = true;
            clear(orders.length - 1).play();
            start();
        }
        private function start():void {
            var tweens:Array = new Array();
            for (var n:uint = 0; n < orders.length; n++) {
                var _tweens:Array = new Array();
                var tid:uint = 0;
                for (var r:uint = 0; r < orders[n].length; r++) {
                    for (var t:uint = 0; t < orders[n][r].length; t++) {
                        var txt:Text = orders[n][r][t];
                        var _tween:ITween = BetweenAS3.delay(BetweenAS3.parallel(
                            BetweenAS3.to(txt, {alpha: 1, visible: 1}, 0.1, Linear.easeNone), 
                            BetweenAS3.to(txt, {x: txt.target.x, y: txt.target.y, scale: 1}, 0.4, Expo.easeOut)
                        ), 0.1*tid);
                        _tweens.push(_tween);
                        tid ++;
                    }
                }
                var tween:ITween = BetweenAS3.parallelTweens(_tweens);
                tweens.push(tween);
                if (n < orders.length - 1) {
                    tweens.push(wait(1));
                    tweens.push(clear(n));
                }
            }
            var itween:ITween = BetweenAS3.serialTweens(tweens);
            itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, true);
            itween.play();
        }
        private function complete(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, complete);
            playBtn.selected = false;
        }
        private function wait(interval:Number):ITween {
            var itween:ITween = BetweenAS3.delay(BetweenAS3.func(null), interval);
            return itween;
        }
        private function clear(id:uint):ITween {
            var itween:ITween = BetweenAS3.func(function ():void {
                for (var r:uint = 0; r < orders[id].length; r++) {
                    for (var t:uint = 0; t < orders[id][r].length; t++) {
                        var txt:Text = orders[id][r][t];
                        txt.base = {x: Math.random()*465, y: Math.random()*425};
                        txt.x = txt.base.x;
                        txt.y = txt.base.y;
                        txt.alpha = 0;
                        txt.visible = false;
                        txt.scale = 8;
                    }
                }
            });
            return itween;
        }
        private function initialize():void {
            orders = new Array();
            txts = new Array();
            for (var n:uint = 0; n < lists.length; n++) {
                var strs:String = lists[n];
                var rlist:Array = strs.split("|");
                orders[n] = new Array();
                for (var r:uint = 0; r < rlist.length; r++) {
                    var rstr:String = rlist[r];
                    var list:Array = rstr.split("");
                    orders[n][r] = new Array();
                    for (var t:uint = 0; t < list.length; t++) {
                        var str:String = list[t];
                        var txt:Text = create(str);
                        orders[n][r].push(txt);
                        txts.push(txt);
                    }
                }
            }
        }
        private function setup():void {
            for (var n:uint = 0; n < orders.length; n++) {
                for (var r:uint = 0; r < orders[n].length; r++) {
                    var prev:Text = null;
                    var total:Number = 0;
                    for (var t:uint = 0; t < orders[n][r].length; t++) {
                        var txt:Text = orders[n][r][t];
                        if (prev) {
                            var pwidth:Number = prev.textWidth;
                            var twidth:Number = txt.textWidth;
                            var interval:Number = (pwidth + twidth)/2 + mwidth;
                            txt.target.x = prev.target.x + interval;
                            total += interval;
                        }
                        prev = txt;
                    }
                    for (t = 0; t < orders[n][r].length; t++) {
                        txt = orders[n][r][t];
                        txt.target.x -= total/2;
                        txt.target.y += mheight*(r - (orders[n].length - 1)/2);
                    }
                }
            }
        }
        private function create(str:String):Text {
            var txt:Text;
            if (str.charCodeAt(0) > 0xFF) {
                txt = new Text(40, 40, 20, Text.CENTER); 
            } else {
                txt = new Text(40, 40, 24, Text.CENTER); 
            }
            container.addChild(txt);
            txt.textColor = 0xFFFFFF;
            txt.text = str;
            txt.filters = [glow];
            txt.target = {x: 232, y: 212};
            txt.x = txt.base.x;
            txt.y = txt.base.y;
            txt.alpha = 0;
            txt.visible = false;
            return txt;
        }
        private function reset():void {
            for (var n:uint = 0; n < txts.length; n++) {
                var txt:Text = txts[n];
                txt.base = {x: Math.random()*465, y: Math.random()*425};
                txt.x = txt.base.x;
                txt.y = txt.base.y;
                txt.alpha = 0;
                txt.visible = false;
                txt.scale = 8;
            }
        }

    }

}


//////////////////////////////////////////////////
// Textクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Text extends Sprite {
    public var id:Object = {id: 0};
    public var txt:TextField;
    private static var fontType:String = "M+ 2p bold";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 24;
    private var _scale:Number = 1;
    public var base:Object = {x: 0, y: 0};
    public var target:Object = {x: 0, y: 0};
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Text(w:uint, h:uint, s:uint = 24, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.x = -uint(_width/2);
        txt.y = -uint(_height/2);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.antiAliasType = AntiAliasType.NORMAL;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(value:String):void {
        txt.text = value;
    }
    public function set textColor(value:uint):void {
        txt.textColor = value;
    }
    public function get textWidth():Number {
        return txt.textWidth;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(value:Number):void {
        _scale = value;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// ProgressBarクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class ProgressBar extends Sprite {
    private var base:Sprite;
    private var bar:Shape;
    private var prog:Shape;
    private var title:TextField;
    private var txt:TextField;
    private static var label:String = "loading...";
    private static var fontType:String = "Myriad Pro Semibold";
    private var _width:uint = 800;
    private static var _height:uint = 40;
    private static var bHeight:uint = 10;
    private static var tWidth:uint = 55;
    private static var tHeight:uint = 20;
    private static var bColor:uint = 0x000000;
    private static var tColor:uint = 0xFFFFFF;
    private static var pColor:uint = 0xFFFFFF;
    private static var eColor:uint = 0xCC0000;
    private var shade:DropShadowFilter;
    private var _percent:Number = 0;
    private var targetPercent:Number;
    private static var interval:uint = 500;
    private static var deceleration:Number = 0.4;
    private var timer:Timer;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "baseFadeOut";

    public function ProgressBar(w:uint) {
        _width = w;
        draw();
        percent = 0;
        visible = false;
    }

    private function draw():void {
        createChildren();
        createText();
    }
    public function update(w:uint):void {
        _width = w;
        base.x = -_width/2;
        createBar(bar, _width, pColor);
        createLine(prog, _width, bColor);
    }
    private function createChildren():void {
        base = new Sprite();
        bar = new Shape();
        prog = new Shape();
        addChild(base);
        base.addChild(bar);
        base.addChild(prog);
        base.x = -_width/2;
        base.y = 8;
        createBar(bar, _width, pColor);
        createLine(prog, _width, bColor);
        bar.mask = prog;
    }
    private function createText():void {
        title = new TextField();
        txt = new TextField();
        addChild(title);
        addChild(txt);
        title.x = -tWidth;
        title.y = -_height/2 + 2;
        title.width = tWidth;
        title.height = tHeight - 2;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        title.embedFonts = true;
        title.antiAliasType = AntiAliasType.NORMAL;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 12;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.textColor = tColor;
        title.text = label;
        txt.x = 0;
        txt.y = -_height/2 + 2;
        txt.width = tWidth;
        txt.height = tHeight - 2;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.NORMAL;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 12;
        tfr.align = TextFormatAlign.RIGHT;
        txt.textColor = tColor;
        txt.defaultTextFormat = tfr;
    }
    public function init():void {
        alpha = 1;
        createBar(bar, _width, pColor);
        percent = 0;
        prog.x = 0;
        prog.scaleX = 0;
        visible = true;
    }
    public function error(e:String):void {
        alpha = 1;
        txt.text = "0%";
        createBar(bar, _width, eColor);
        prog.scaleX = 1;
        visible = true;
    }
    public function progress(l:Number, t:Number):void {
        targetPercent = Math.round(l/t*100);
        addEventListener(Event.ENTER_FRAME, progressTo, false, 0, true);
    }
    private function progressTo(evt:Event):void {
        percent += (targetPercent - percent)*deceleration;
        if (Math.abs(targetPercent - percent) < 0.5) {
            percent = targetPercent;
            removeEventListener(Event.ENTER_FRAME, progressTo);
        }
        if (percent >= 100) {
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER, fadeOut, false, 0, true);
            timer.start();
        }
    }
    private function fadeOut(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, fadeOut);
        addEventListener(Event.ENTER_FRAME, reduction, false, 0, true);
    }
    private function reduction(evt:Event):void {
        prog.x += (_width - prog.x)*deceleration;
        if (Math.abs(_width - prog.x) < 0.5) {
            prog.x = _width;
            removeEventListener(Event.ENTER_FRAME, reduction);
            addEventListener(Event.ENTER_FRAME, baseFadeOut, false, 0, true);
            dispatchEvent(new Event(ProgressBar.FADE_OUT));
        }
    }
    private function baseFadeOut(evt:Event):void {
        var speed:Number = 0.1;
        alpha -= speed;
        if (alpha <= 0) {
            removeEventListener(Event.ENTER_FRAME, baseFadeOut);
            alpha = 0;
            visible = false;
            dispatchEvent(new Event(ProgressBar.BAR_FADE_OUT));
        }
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(value:Number):void {
        _percent = value;
        manage(_percent);
    }
    private function manage(p:Number):void {
        txt.text = String(Math.round(p)) + "%";
        prog.scaleX = p/100;
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint, color:uint):void {
        target.graphics.beginFill(color);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }
    private function createLine(target:Shape, w:uint, color:uint, alpha:Number = 1):void {
        target.graphics.clear();
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRect(0, 0, w, 1);
        target.graphics.endFill();
    }
    private function createBar(target:Shape, w:uint, color:uint):void {
        target.graphics.clear();
        target.graphics.beginFill(color);
        target.graphics.drawRect(0, 0, w, 1);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// FontLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.text.Font;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.LoaderContext;
import flash.utils.getDefinitionByName;

class FontLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    private var _className:String;
    private var _font:Font;
    private var _fontName:String;
    private var embeded:Boolean = false;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FontLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, name:String, e:Boolean = false):void {
        _className = name;
        embeded = e;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            var context:LoaderContext = new LoaderContext();
            context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
            loader.load(new URLRequest(file), context);
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(FontLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(FontLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(FontLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        dispatchEvent(new Event(FontLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        var FontClass:Class = Class(ApplicationDomain.currentDomain.getDefinition(className));
        if (!embeded) {
            Font.registerFont(FontClass);
            _font = Font(new FontClass());
        } else {
            var document:Object = new FontClass();
            _font = document.font;
        }
        _fontName = _font.fontName;
        dispatchEvent(new Event(FontLoader.COMPLETE));
    }
    public function get className():String {
        return _className;
    }
    public function get font():Font {
        return _font;
    }
    public function get fontName():String {
        return _fontName;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "Myriad Pro Semibold";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var disableColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
            case 1 :
                bColor = 0xFFFFFF;
                sColor = 0x000000;
                upColor = 0x666666;
                overColor = 0x333333;
                disableColor = 0x999999;
                break;
            case 2 :
                bColor = 0x000000;
                sColor = 0xFFFFFF;
                upColor = 0x666666;
                overColor = 0x999999;
                disableColor = 0x333333;
                break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 14;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _disable():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = disableColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(value:Boolean):void {
        _selected = value;
        enabled = !_selected;
        if (_selected) {
        _down();
        } else {
        _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(value:Boolean):void {
        _enabled = value;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
        _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
