/**
 * Copyright matyui ( http://wonderfl.net/user/matyui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gvYX
 */

//perlin noise
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Point;
	import flash.net.URLRequest;

	public class PerlinNoise extends Sprite {
		
		private var bmpdata:BitmapData;
		private var bmp:Bitmap;
		private var mcArr:Array = new Array();
		private var ImgLoader:Loader = new Loader();
		private var ImgUrl:URLRequest = new URLRequest("http://farm4.static.flickr.com/3410/3641980004_06295c188c.jpg?v=0");
		
		private var pointArr:Array = [new Point(0,0),new Point(0,0)];
		
		private var sp:Sprite = new Sprite();
		
		public function PerlinNoise() {
			bmpdata = new BitmapData( 50, 50, true);
			stage.addChild(sp);
			
			ImgLoader.load(ImgUrl);
			
			stage.addChild(ImgLoader);
			
			for(var i:Number = 0; i <= stage.stageWidth / 100; i++){
				
				mcArr[i] = new Array();
				
				for(var j:Number = 0; j <= stage.stageHeight / 100; j++){
					var rrect:Shape = new Shape();
					var graph:Graphics = rrect.graphics;
					bmp = new Bitmap(bmpdata);
					graph.beginFill (0x000000, 1.0);
					graph.drawRoundRect  ( -50, -50 , 100 , 100 , 30 , 30);
					rrect.x = 50 + 100*i;
					rrect.y = 50 + 100*j;
					
					sp.addChild(rrect);
					
					mcArr[i].push(rrect);//2D 配列
					
				}
			}
	
			ImgLoader.mask = sp;
			addEventListener( Event.ENTER_FRAME, scaleTransition );
			
			
		}
		
		private function scaleTransition( e:Event ):void {
			pointArr[0].x += 2;
			pointArr[1].y += 2;
			bmpdata.perlinNoise(50, 50, 3, 8000, false, true, 4 | 2 | 1, false, pointArr);
			for(var i:Number = 0; i <= stage.stageWidth / 100; i++){
				for(var j:Number = 0; j <= stage.stageHeight / 100; j++){
					var color_num:int = bmpdata.getPixel(5*(i+1),5*(j+1)) >> 16;
					mcArr[i][j].scaleX = mcArr[i][j].scaleY = -0.8 + 3*color_num/255;
				}
			}
			
		}
	}
}