/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/guE1
 */

package {
    
    import flash.display.Sprite
    import flash.events.Event
    
    [SWF(width=400, height=400, backgroundColor=0xffffff, frameRate=60)]
    public class RotateToAvoid extends Sprite {
        
        private var container:Sprite = new Sprite
        
        public function RotateToAvoid() {
            addChild(container)
            makeUnits(30)
            addEventListener("enterFrame", update)
        }
        
        private function makeUnits(num:int):void {
            if(num <= 0) throw new Error("invalid numUnits")
            var unit:Unit
            while(num--){
                unit = container.addChild(new Unit) as Unit
                unit.x = Math.random() * stage.stageWidth
                unit.y = Math.random() * stage.stageHeight
            }
        }
        
        private function update(e:Event):void {
            var a:Unit, b:Unit
            for(var i:int=0 ; i<container.numChildren ; i++){
                a = container.getChildAt(i) as Unit
                if(a.partner){
                    rotate(a, a.partner)
                    if(willDepart(a, a.partner)) a.partner.partner = a.partner = null
                }else{
                   a.x += a.vx ; a.y += a.vy 
                }
                if(a.x<0){ a.x=0 ; a.vx *= -1 }
                if(a.x>stage.stageWidth){ a.x=stage.stageWidth ; a.vx *= -1 }
                if(a.y<0){ a.y=0 ; a.vy *= -1 }
                if(a.y>stage.stageHeight){ a.y=stage.stageHeight ; a.vy *= -1 }

                for(var j:int=i+1 ; j<container.numChildren ; j++){
                    b = container.getChildAt(j) as Unit
                    if(hit(a, b)){
                        rotate(a, b)
                        a.partner = b ; b.partner = a
                        break
                    }
                }
            }
        }
        
        private function willDepart(a:Unit, b:Unit):Boolean {
            var px:Number = b.x - a.x , py:Number = b.y - a.y
            return a.vx*px + a.vy*py <= 0
        }
        private function distanceSquared(x0:Number,y0:Number, x1:Number,y1:Number):Number {
            var dx:Number = x0 - x1 , dy:Number = y0 - y1
            return dx*dx + dy*dy
        }
        private function hit(a:Unit, b:Unit):Boolean {
            return distanceSquared(a.x+a.vx, a.y+a.vy, b.x+b.vx, b.y+b.vy) < Math.pow(Unit.SIZE+Unit.SIZE,2)
        }
        
        private var dt:Number = 3 * Math.PI/180 // 회전 속도
        private var cos:Number = Math.cos(dt) , sin:Number = Math.sin(dt)
        private function rotate(a:Unit, b:Unit):void {
            var cx:Number = (a.x+b.x)/2 , cy:Number = (a.y+b.y)/2
            var tempx:Number
            
            if(hit(a, b)){
                var dx:Number = b.x - a.x , dy:Number = b.y - a.y
                var d:Number = Math.sqrt(dx*dx + dy*dy)
                a.x -= dx/d ; b.x += dx/d
                a.y -= dy/d ; b.y += dy/d
            }
            
            a.x -= cx ; a.y -= cy
            tempx = a.x
            a.x = cos*a.x - sin*a.y
            a.y = sin*tempx + cos*a.y
            a.x += cx ; a.y += cy
            
            b.x -= cx ; b.y -= cy
            tempx = b.x
            b.x = cos*b.x - sin*b.y
            b.y = sin*tempx + cos*b.y
            b.x += cx ; b.y += cy
        }
        
    }
    
}

import flash.display.Shape
class Unit extends Shape {
    
    public static const SIZE:Number = 10
    
    public var vx:Number, vy:Number
    public var partner:Unit
    
    public function Unit() {
        graphics.beginFill(0x123456, 1)
        graphics.drawCircle(0, 0, SIZE)
        graphics.endFill()
        var ang:Number = Math.random()*Math.PI*2
        vx = Math.cos(ang) * 2
        vy = Math.sin(ang) * 2
    }
    
}
