/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gtg2
 */

/*
 * はてなのホットエントリーのサムネール一覧を表示してみる。
 * 
 * はてなのホットエントリーのURLを取得
 * http://b.hatena.ne.jp/hotentry
 * ↓
 * サムネール画像を自動生成するサービス
 * http://img.simpleapi.net/
 * ↓
 * 表示。
 * 
 * ＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝
 * Namespaceがどうも慣れない。毎回試行錯誤してしまう。
 * 
 * */


package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Loader;
	import flash.net.navigateToURL;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite {
		private var myTimer:Timer = new Timer(1000, 1);
		private var hotentryLoader:URLLoader = new URLLoader();
		private var link_array:Array = [];
		private var title_array:Array = [];
        private var loadFiles_array:Array;
		private var MultiLoader:MultiLoaderClass = new MultiLoaderClass();
		public function Main():void {
			//タイトル表示
			var tf:TextField = new TextField();
			addChild(tf)
			tf.width = 465;
			tf.text = "はてなのホットエントリーのサムネール一覧を表示してみる。";
			//はてなのホットエントリーのfeedを取得
			hotentryLoader.addEventListener (Event.COMPLETE,hotentryCOMPLETE);
			hotentryLoader.load(new URLRequest("http://feedproxy.google.com/hatena/b/hotentry"));
		}
		public function hotentryCOMPLETE (event : Event):void {
			//ネームスペースを設定
			var ns:Namespace = new Namespace("http://purl.org/rss/1.0/");
			var feed:XML = new XML(hotentryLoader.data);
			//リンクのURLを取得
			var _length:int = Math.min(feed.ns::item.length(),9);
			for (var i:int = 0; i < _length; i++) {
				//サムネール画像のURLにする。
				link_array[i] = "http://img.simpleapi.net/small/" + String(feed.ns::item[i].ns::link);
				title_array[i] = String(feed.ns::item[i].ns::title);
			}
			//サムネール画像をロード
			loadFiles_array = MultiLoader.setLoad(link_array,thumbCOMPLETE);
		}
		public function thumbCOMPLETE (event : Event = null):void {
			//画像を配置
			for (var i:int = 0; i < loadFiles_array.length; i++) {
				var sp:Sprite = new Sprite();
				sp.x = (i % 3) * 150 + 18;
				sp.y = Math.floor(i / 3) * 150 + 20;
				sp.buttonMode = true;
				loadFiles_array[i].name = String(i);
				var tf:TextField = new TextField();
				tf.x = (i % 3) * 150 + 18;
				tf.y = Math.floor(i / 3) * 150 + 20+128;
				tf.width = 128;
				tf.height = 18;
				tf.text = title_array[i];
				tf.setTextFormat((new TextFormat(null, 10)));
				stage.addChild(tf);
				sp.addChild(loadFiles_array[i]);
				stage.addChild(sp);
			}
			//クリックしたら、リンク先に飛ぶ
			stage.addEventListener(MouseEvent.CLICK, onClick);
			function onClick(e:MouseEvent):void {
				if(parseInt(e.target.name)){
					navigateToURL(new URLRequest( link_array[int(e.target.name)].substr(31) ));
				}
			}
		}
	}
}




class MultiLoaderClass{
	import flash.system.Security;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.display.Loader;

	private var onComplete:Function = function():void{};
	private var loadNum:int;
	private var loadCompNum:int;

	public function MultiLoaderClass(_str:String = null){
		if(_str != null){
			Security.loadPolicyFile(_str);
		}
	}

	public function setLoad(__item_array:Array,_onComp:Function = null):Array{
		loadCompNum = loadNum = 0;
		onComplete = _onComp;
		var _array:Array = new Array();
		var _length:int = __item_array.length;
		for (var i:int = 0; i < _length; i++) {
			if(__item_array[i] == null){continue};
			var _extension:String = __item_array[i].substr(-4,4).toLowerCase();//拡張子を取り出す。
			if(_extension == ".xml"){
				loadNum ++;
				_array[i] = fnURLLoader(__item_array[i]);
			}else if(_extension == ".jpg" || _extension == ".png" || _extension == ".gif"){
				loadNum ++;
				_array[i] = fnLoader(__item_array[i]);
			}else {
				//.html
				loadNum ++;
				_array[i] = fnLoader(__item_array[i]);
				//_array[i] = null;
			}
		}
		return _array;
	}
	private function fnURLLoader(__url:String):URLLoader{
		var _loader : URLLoader = new URLLoader();
		_loader.load(new URLRequest(__url));
		_loader.addEventListener (Event.COMPLETE,completeHandler);
		_loader.addEventListener (IOErrorEvent.IO_ERROR, ioErrorHandler);
		return _loader;
	}

	private function fnLoader(__url:String):Loader{
		var _loader:Loader = new Loader();
		_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
		_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
		_loader.load(new URLRequest(__url));
		//_loader.name = __url;
		return _loader;
	}

	private function completeHandler(event:Event = null):void {
		loadCompNum ++;
		if(loadCompNum == loadNum){
			onComplete();
		}
		//var loaderInfo:LoaderInfo=event.currentTarget as LoaderInfo;
		//var loader:Loader=loaderInfo.loader;
		//addChild(loader);
	}

	private function ioErrorHandler(event:IOErrorEvent):void {
		//event.text = "Error #2035: URL が見つかりません。 URL: file:///~~~~~";
		//event.text = "Error #2036: 読み込みが未完了です。 URL: http://~~~~~";
		//から、URLのみを取り出す。
		//trace(String(event.text).substr(String(event.text).indexOf(" URL: ")+6),"*****");
		completeHandler();
	}
}