/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gt4A
 */

package {
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class CATest extends Sprite {
        private var canvas:BitmapData = new BitmapData(400,400,false);
        private var rule:Vector.<int> = Vector.<int>([0,1,1,1,0,1,1,0]);
        private var w:int = 400,h:int = 400;
        private var row:int = 1;
        
        public function CATest() {
            addChild(new Bitmap(canvas));
            canvas.fillRect(new Rectangle(0,0,w,h),0xFFFFFF);
            canvas.setPixel(0,0,0);
            this.addEventListener(Event.ENTER_FRAME,draw);
        }
        public function reset():void{
            canvas.fillRect(new Rectangle(0,0,w,h),0xFFFFFF);
            canvas.setPixel(0,0,0x000000);
            for(var i:int = 0 ; i < rule.length; i++) rule[i] = int(Math.random() > .5);
            trace(rule);
        }
        public function draw(event:Event):void{
            canvas.lock();
            for(var i:int = 0 ; i < width; ++i){
                var a:int = canvas.getPixel((i-1+w)%w,row-1);
                var b:int = canvas.getPixel(i,row-1);
                var c:int = canvas.getPixel((i+1+w)%w,row-1);
                var num:int = 0;
                if(a == 0) num+= 1;
                if(b == 0) num+= 2;
                if(c == 0) num+= 4;
                if(rule[num] == 1) canvas.setPixel(i,row,0);
            }
            row++;
            canvas.unlock();
            if(row > h) {
                reset();
                row = 1;
            }
        }
    }
}