/**
 * Copyright sh0ckwav ( http://wonderfl.net/user/sh0ckwav )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gsAP
 */

// forked from sh0ckwav's  Example: Perspective projection
package 
{ 
    import flash.display.Sprite; 
    import flash.display.Shape; 
    import flash.geom.Point; 
    import flash.events.*; 
    public class ProjectionDragger extends Sprite 
    { 
        private var center : Sprite; 
        private var boxPanel:Shape; 
        private var inDrag:Boolean = false; 
         
         public function ProjectionDragger():void 
        { 
            createCircles(); 
            createCenter(); 
        }  
         public function createCenter():void 
         {   
              var  centerRadius:int = 20; 
     
              center = new Sprite(); 
     
              // cross hairs 
              center.graphics.lineStyle(1, 0x000099);
              center.graphics.moveTo(0, centerRadius); 
              center.graphics.lineTo(0, -centerRadius); 
              center.graphics.moveTo(centerRadius, 0); 
              center.graphics.lineTo(-centerRadius, 0); 
              center.x = 175; 
              center.y = 175; 
              center.z = 0; 
              this.addChild(center); 
     
              //center.addEventListener(MouseEvent.MOUSE_DOWN, startDragProjectionCenter); 
              //center.addEventListener(MouseEvent.MOUSE_UP, stopDragProjectionCenter); 
              stage.addEventListener( MouseEvent.MOUSE_MOVE, doDragProjectionCenter); 
              center.startDrag(true); 
              inDrag = true; 
              root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y); 
        } 
        public function createCircles():void 
        { 
            var radius:int = 50; 
            var numLayers:int = 12; 
            var depthPerLayer:int = 50; 
             
            for (var i:int = 0; i < numLayers; i++) 
            { 
                this.addChild(createCircle(stage.stageWidth / 2, radius, (numLayers - i) * depthPerLayer, radius, 0xCCCCFF)); 
                this.addChild(createCircle(50, stage.stageHeight / 2, (numLayers - i) * depthPerLayer, radius, 0xFFCCCC)); 
                this.addChild(createCircle(stage.stageWidth - radius, stage.stageHeight / 2, (numLayers - i) * depthPerLayer, radius, 0xCCFFCC)); 
                this.addChild(createCircle(stage.stageWidth / 2, stage.stageHeight - radius, (numLayers - i) * depthPerLayer, radius, 0xDDDDDD)); 
            } 
        } 
         
        public function createCircle(xPos:int = 0, yPos:int = 0, zPos:int = 100, r:int = 50, color:int = 0xDDDDDD):Shape 
        { 
            var box:Shape = new Shape(); 
            box.graphics.lineStyle(2, 0x666666); 
            box.graphics.beginFill(color, 1.0); 
            box.graphics.drawCircle(0, 0, r); 
            box.graphics.endFill(); 
            box.x = xPos; 
            box.y = yPos; 
            box.z = zPos; 
            return box; 
        } 
        public function startDragProjectionCenter(e:Event):void
        {  
            center.startDrag(); 
            inDrag = true; 
        } 
         
        public function doDragProjectionCenter(e:Event):void
        {  
            if (inDrag) 
            { 
                root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y); 
            } 
        } 
         
        public function stopDragProjectionCenter(e:Event):void
        { 
            center.stopDrag();  
            root.transform.perspectiveProjection.projectionCenter = new Point(center.x, center.y); 
            inDrag = false; 
        } 
    } 
}
