/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/grvD
 */

//
//    EcoChristmasTree
//        今流行のエコツリー。
//
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Graphics;
    
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    
    [SWF(width = "465", height = "465")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var _backcanvas:BitmapData;
        private var _canvas:BitmapData;
        private var _sprite:Sprite;
        
        private var _tree:Tree;
        
        private var _lamps:Vector.<Lamp>;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
    
            _backcanvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap( _backcanvas ) );
            
            _canvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap( _canvas ) );
            
            
            _sprite = new Sprite();
            _sprite.filters = [new BlurFilter(20, 20, 3), new GlowFilter(0xFFFFFF, 0.5, 20, 20, 2, 3, false, false)];
            _sprite.blendMode = "add";
            addChild( _sprite );
            
            _tree = new Tree(WIDTH / 2, 400);
            
            
            _lamps = new Vector.<Lamp>();
            
            
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function Update(e:Event):void
        {
            _tree.Update();
            
            _sprite.graphics.clear();

            var lampnum:int = _lamps.length;
            for ( var i:int = lampnum-1; i >= 0 ; i-- )
            {
                var lamp:Lamp = _lamps[i];
                lamp.Update();
                if ( !lamp.flgflash )    _lamps.splice( i, 1 );
                else
                {
                    _sprite.graphics.beginFill( lamp.color, Math.min( lamp.flashrate, 0.8) );
                    _sprite.graphics.drawCircle( lamp.x, lamp.y, lamp.size );
                    _sprite.graphics.endFill();
                }
            }
            
            _canvas.lock();
            _backcanvas.applyFilter( _backcanvas, _backcanvas.rect, new Point(), new BlurFilter(20,20,3) );
            _canvas.fillRect( _canvas.rect, 0 );
            _canvas.draw( _tree, new Matrix( 1, 0, 0, 1, _tree.x, _tree.y) );    
            _backcanvas.draw( _canvas );
            _canvas.unlock();
            
            if ( int(Math.random() * 10) == 0 )
            {
                AddLamp();
            }
        }
        
        private function AddLamp() : void
        {
            var lamp:Lamp = new Lamp(Math.random() * WIDTH, Math.random() * HEIGHT, 0 );
            lamp.size = Math.random() * 50 + 5;
            var colorno:int = int(Math.random() * 3);
            if ( colorno == 0 )    lamp.color = 0xFF5555;
            if ( colorno == 1 )    lamp.color = 0xFFFF55;
            if ( colorno == 2 )    lamp.color = 0x5555FF;
            
            lamp.StartFlash();
            _lamps.push( lamp );
        }
        
    }
    
}
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Graphics;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.Sprite;

const WIDTH:int = 465;
const HEIGHT:int = 465;




class Lamp {
    private static const STEP:int = 30;
    
    private var _x:Number;
    private var _y:Number;
    private var _angle:Number;
    
    private var _flg_flash:Boolean;
    public function get flgflash():Boolean { return _flg_flash;    }
    private var _flashstep:int;
    
    public function get flashrate() : Number { return    Math.sin( _flashstep / STEP * Math.PI );    }
    
    public var size:Number;
    public var color:uint;
    
    
    public function Lamp( x:Number, y:Number, angle:Number ) {
        this._x = x;
        this._y = y;
        this._angle = angle;
        EndFlash();
    }
    
    public function get x():Number {
        return    _x * Math.cos( _angle * Math.PI / 180 );
    }
    public function get y():Number {
        return    _y;
    }
    
    public function AddAngle( val:Number ) : void
    {
        _angle = (_angle + val) % 360;
    }
    
    public function StartFlash() : void
    {
        _flg_flash = true;
        _flashstep = 0;
    }
    public function EndFlash() : void
    {
        _flg_flash = false;
        _flashstep = 0;
    }
    
    public function Update() : void
    {
        if ( _flg_flash )
        {
            if ( _flashstep == STEP )    EndFlash();
            else
            {
                _flashstep++;    
            }
        }
    }

}

class TreeOutLine {
    public var angle:Number;
    public var startY:Number;
    public var endY:Number;
    public var peakY:Number;
    public var peakLength:Number;
    
    public var lampNum:int;
    public var lamps:Vector.<Lamp>;
    
    public function TreeOutLine(startY:Number, endY:Number, peakY:Number, peakLength:Number, angle:Number, lampNum:Number) {
        this.startY = startY;
        this.endY = endY;
        this.peakY = peakY;
        this.peakLength = peakLength;
        this.angle = angle;
        this.lampNum = lampNum;
        lamps = new Vector.<Lamp>( lampNum, true );
        
        //    電球を初期化する
        var rate:Number = 0;
        var prate:Number;
        for ( var i:int = 0; i < lampNum; i++ )
        {
            rate = i / lampNum;
            var lx:Number = 0;
            var ly:Number = startY + (endY - startY) * rate;
            
            if ( ly >= peakY ) {
                prate = 1 - (ly - peakY) / (endY - peakY);            
            }else
            {
                prate = (ly - startY) / (peakY - startY);
            }
            lx = peakLength * prate;
                
            var lamp:Lamp = new Lamp( lx, ly, angle );
            lamps[i] = lamp;
        }
    }
    
    public function AddAngle( val:Number ) : void
    {
        angle = (angle + val) % 360;
        var num:int = lamps.length;
        for ( var l:int = 0; l < num; l++ )
        {
            lamps[l].AddAngle( val );
        }
    }
}

class Tree extends Sprite {
    //public var x:Number;
    //public var y:Number;
    
    public var outLines:Vector.<TreeOutLine>;
    
    public var starobj:StarObj;
    
    private var _step:int;
    
    private var _tree:Shape;

    public function Tree(x:Number, y:Number) {
        
        this.x = x;
        this.y = y;
        
        outLines = new Vector.<TreeOutLine>();
        
        var i:int = 0;
        var num:int = 40;
        for ( i = 0; i < num; i++ )
        {
            var outline:TreeOutLine = new TreeOutLine( -300, 0, -30, 150, (i / num) * 360, 50 );
            outLines.push( outline );
        }
        
        starobj = new StarObj();
        _tree = new Shape();
        
        _step = 0;
        
        addChild( _tree );
        addChild( starobj.shape );
        starobj.shape.y = -300;
        
    }
    
    public function Rotation( rot:Number ) : void
    {
        var num:int = outLines.length;
        for ( var i:int = 0; i < num; i++ )
        {
            var outline:TreeOutLine = outLines[i];
            outline.AddAngle( rot );
        }
    }
    
    public function Update() : void
    {
        starobj.LightingStep();
        Rotation( 0.5 );
        
        var num:int = outLines.length;
        for ( var i:int = 0; i < num; i++ )
        {
            var outline:TreeOutLine = outLines[i];
            var lamps:Vector.<Lamp> = outline.lamps;
            var lampnum:int = lamps.length;
            for ( var l:int = 0; l < lampnum; l++ )
            {
                var lamp:Lamp = lamps[l];
                lamp.Update();
                
                if ( _step % 30 == l % 30 )    lamp.StartFlash();
            }
        }
        
        Draw();
        
        _step++;
    }

    public function Draw() : void
    {
        var g:Graphics = _tree.graphics;
        g.clear();
        
        g.lineStyle( 1, 0xFFFFFF );
            
        var outlinenum:int = outLines.length;
        for ( var o:int = 0; o < outlinenum; o++ )
        {
            var lampnum:int = outLines[o].lamps.length;
            var lamps:Vector.<Lamp> = outLines[o].lamps;
                
            if ( outLines[o].angle < 180 )
            {
                for ( var l:int = 0; l < lampnum; l++ )
                {
                    var lamp:Lamp = lamps[l];
                    //canvas.setPixel32( treeX + lamp.x, treeY + lamp.y, 0xFFFFFFFF );
                    g.beginFill( 0x0000FF, lamp.flashrate );
                    g.drawCircle( lamp.x, lamp.y, 1 + lamp.flashrate * 2 );
                    g.endFill();
                    g.drawCircle( lamp.x, lamp.y, 1 );
                }
            }
        }
    }
}

class StarObj {
    
    public var bmd:BitmapData;
    public var shape:Shape;
    
    public static const SIZE:int = 50;
    
    
    public var lightcount:int = 0;
    public var alpha:Number;
    
    public var color:ColorTransform;
    
    public function StarObj() {
        
        shape = new Shape();
        var g:Graphics = shape.graphics;
        
        g.lineStyle( 2, 0xFFFF00 );
        for ( var i:int = 0; i < 11; i++ )
        {
            var radius:Number = 20;
            var angle:Number = (90 + i * (360 / 10)) % 360;
            if ( i % 2 == 0 )    radius = 10;
            var xx:Number = Math.cos( angle * Math.PI / 180 ) * radius;
            var yy:Number = Math.sin( angle * Math.PI / 180 ) * radius;
            if ( i == 0 )    g.moveTo( xx, yy );
            else             g.lineTo( xx, yy );
        }
        
        bmd = new BitmapData( 50, 50, true, 0 );
        bmd.draw( shape, new Matrix( 1, 0, 0, 1, 25, 25 ) );
        
        color = new ColorTransform(0,0,0,0,255,255,0,0);
        
        lightcount = 0;
        UpdateAlpha();
    }

    public function LightingStep() : void
    {
        lightcount = (lightcount + 1) % 60;
        UpdateAlpha(); 
    }
    
    private function UpdateAlpha() : void
    {
        alpha = Math.max( Math.sin( (lightcount / 60) * 360 * Math.PI / 180), 0.8);
        color.alphaMultiplier = 0;
        color.alphaOffset = alpha * 255;
        shape.alpha = alpha;
    }
}


