/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/grFa
 */

package {
	import flash.display.Sprite;
	
	import org.as3lib.kitchensync.KitchenSync;
	import org.as3lib.kitchensync.action.group.IActionGroup;
	import org.as3lib.kitchensync.action.group.KSParallelGroup;
	import org.as3lib.kitchensync.action.group.KSSequenceGroup;
	import org.as3lib.kitchensync.action.tween.KSSimpleTween;
	import org.as3lib.kitchensync.easing.Cubic;
	import org.as3lib.kitchensync.easing.Elastic;
	
	[SWF(width="500", height="500", frameRate="50", backgroundColor="#FFFFFF")]
	
	public class MyFirstGroup extends Sprite {
		
		public function MyFirstGroup() {
			super();
			KitchenSync.initialize(this);
			
			var sprite:Sprite = new Sprite();
			sprite.graphics.beginFill(0);
			sprite.graphics.drawRect(5, 5, 25, 25);
			addChild(sprite);
			 
			var parallel:IActionGroup = new KSParallelGroup (
				new KSSimpleTween(sprite, "scaleX", 1, 3, 1000, 0, Elastic.easeOut),
				new KSSimpleTween(sprite, "scaleY", 1, 3, 1000, 0, Elastic.easeOut)
			);
			
			var sequence:IActionGroup = new KSSequenceGroup (
				new KSSimpleTween(sprite, "x", 0, 400, 1000, 0, Cubic.easeInOut),
				parallel, 
				new KSSimpleTween(sprite, "x", 400, 0, 1000, 0, Cubic.easeInOut)
			);
				
			sequence.start(); 
		}
	}
}