/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gr4g
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;

        [SWF (backgroundColor = "0xFFFFFF", frameRate = "30")]
	public class FrontStudy extends Sprite
	{
		private const TEXT_FORMAT:TextFormat = new TextFormat("PF Ronda Seven", 8, 0x666666);
		private var _hoursHand:Hand;
		private var _minutesHand:Hand;
		private var _secondsHnad:Hand;
		private var _textField:TextField;
		
		private var _preDate:Date;
		
		public function FrontStudy()
		{
			draw();
			addEventListener(Event.ENTER_FRAME , handleEnterFrame);
		}
		
		private function draw():void
		{
			_hoursHand = new Hand(stage.stageWidth/2, stage.stageHeight/2, 2, 50, 0x666666);
			_minutesHand = new Hand(stage.stageWidth/2, stage.stageHeight/2, 2, 80, 0x666666);
			_secondsHnad = new Hand(stage.stageWidth/2, stage.stageHeight/2, 1, 90, 0xff0000);
			
			_textField = new TextField();
			_textField.autoSize = TextFieldAutoSize.LEFT;
			_textField.defaultTextFormat = TEXT_FORMAT;
			_textField.x = 3*stage.stageWidth/4;
			_textField.y = stage.stageHeight/2 - 20;
			
			addChild(_secondsHnad);
			addChild(_minutesHand);
			addChild(_hoursHand);
			addChild(_textField);
		}
		
		private function handleEnterFrame(e:Event):void
		{
			var date:Date = new Date();
			
			if(_preDate != null && _preDate.milliseconds == date.milliseconds)
				return;
				
			_preDate = date;
			
			updateAnalog(date);
			updateDigital(date);
		}
		
		private function updateAnalog(date:Date):void
		{
			_hoursHand.rotation = (360 / 12)*date.hours 
						+ (360 / (12*60))*date.minutes 
						+ (360 / (12*60*60))*date.seconds
						+ (360 / (12*60*60*1000))*date.milliseconds;
						
			_minutesHand.rotation = (360 / 60)*date.minutes
						+ (360 / (60*60))*date.seconds
						+ (360 / (60*60*1000))*date.milliseconds;
						
			_secondsHnad.rotation = (360 / 60 ) * date.seconds
						+ (360 / (60*1000))*date.milliseconds;
		}
		
		private function updateDigital(date:Date):void
		{
			_textField.text = convert(date.hours) + ":"
						+ convert(date.minutes) + ":"
						+ convert(date.seconds) + "\n"
						+ convert(date.milliseconds,4);
		}
		
		private function convert(num:Number, len:int=2):String
		{
			var str:String = String(num);
			
			while(str.length < len)
				str = "0" + str;

			return str;
		}
	}
}


import flash.display.Sprite;

class Hand extends Sprite{
	
	public function Hand(ax:Number=0, ay:Number=0, w:Number=3, h:Number=50, color:uint=0x333333)
	{
		this.x = ax;
		this.y = ay;
		
		graphics.beginFill(color);
		graphics.drawRect(-w/2,-h,w,h);
		graphics.endFill();
	}
}
