/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gqer
 */

package {
  import flash.display.Sprite;
  import funnel.*;
  import funnel.ui.*;

  public class SetPointExample extends Sprite {
    private var arduino:Arduino;

    // LED（D9ピンに接続）
    private var led:LED;

    // 光センサに接続したアナログピン（A0）
    private var sensorPin:Pin;

    public function SetPointExample() {
      // D9のピンモードを出力に設定
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, OUT);
      arduino = new Arduino(config);

      // センサとLEDに接続したピンを表す変数を初期化
      sensorPin = arduino.analogPin(0);
      led = new LED(arduino.digitalPin(9));

      // センサピンに閾値0.5、ヒステリシス0.1のSetPointフィルタをセット
      // 反応が鈍い（あるいは鋭すぎる）場合にはここを調整する
      sensorPin.addFilter(new SetPoint([0.5, 0.1]));

      // センサピンの値が変化した時に発生するイベントに対してリスナをセット
      sensorPin.addEventListener(PinEvent.RISING_EDGE, 
                                 onBrightenUp);
      sensorPin.addEventListener(PinEvent.FALLING_EDGE, 
                                 onDarkenUp);
    }

    // 暗くなったらLEDを点灯
    private function onBrightenUp(e:PinEvent):void {
      led.off();
    }

    // 明るくなったらLEDを消灯
    private function onDarkenUp(e:PinEvent):void {
      led.on();
    }
  }
}
