/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gqVq
 */

// forked from enecre's flash on 2010-11-06
package {
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    import com.bit101.components.*;    
    
    public class FlashTest extends Sprite {
        
        private var tf:TextField = new TextField();
        private var it:InputText;
        
        private var tehai:Tehai;
        
        public function FlashTest() {
            // write as3 code here..
            var defaultInput:String = "123m456p789s2244z";
            
            tf.width = 465;
            tf.height = 465 - 70;
            tf.x = stage.stageWidth / 2 - tf.width / 2;
            tf.y = 70;
            addChild(tf);
            it = new InputText(this, 0, 0, defaultInput, onInput);
            it.width = 150;
            it.x = stage.stageWidth / 2 - it.width / 2;
            it.y = 50;
            addChild(new PushButton(this, 20, 48, "Clear", clearText));
            addChild(new PushButton(this, 340, 48, "Execute", onButton));
            
            Tehai.tr = this.tr;
        }
        
        private function start():void{
            tr("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
            tr(tehai);
            tr("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
            tehai.analyze();
        }
        
        private function mpsToArray(mps:String):Array{
            var reg:Array = /((\d+?)m)?((\d+?)p)?((\d+?)s)?((\d+?)z)?/.exec(mps);
            if(!reg)return [];
            var arr:Array = [];
            var l:int = mps.length;
            var mode:int = 3;
            var map:Array = [ 4, 0, 1, 2, 3, 4, 5, 6, 7, 8,
                             13, 9,10,11,12,13,14,15,16,17,
                             22,18,19,20,21,22,23,24,25,26,
                             -1,27,28,29,30,31,32,33
                            ];
            loop: while(l--){
                var ch:String = mps.charAt(l);
                switch(ch){
                    case "z": {mode = 3; continue loop;}
                    case "s": {mode = 2; continue loop;}
                    case "p": {mode = 1; continue loop;}
                    case "m": {mode = 0; continue loop;}
                    default: break;
                }
                arr.push(map[mode * 10 + int(ch)]);
            }
            return arr.reverse();
        }
        
        private function onButton(e:Event):void{
            tehai = new Tehai(mpsToArray(it.text));
            start();
        }

        
        private function onInput(e:Event):void{
            var text:String = (e.currentTarget as InputText).text;
            var result:Object = /(.+?)\@/.exec(text);
            if(!result)return;
            tehai = new Tehai(mpsToArray(result[1]));
            start();
        }
        
        private function clearText(e:Event = null):void{
            tf.text = "";
        }

        private function tr(...o:Array):void{
            tf.appendText(o + "\n");
            tf.scrollV = tf.maxScrollV;
        }

    }
}

class Tehai {
    public static var tr:Function;
    
    private var _tehai:Array;
    private var _devisions:Array;
        
    public function Tehai(tehai:Array){
        _tehai = tehai;
        _devisions = [];
    }
    
    public function analyze():void{
        var t34:Array = to34();
        var koritsu:Array = [0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0];
        //孤立牌の除去
            //数牌
        for(var i:int = 0; i < 3; i++){
            for(var j:int = 0; j < 9; j++){
                var k:int = i * 9 + j;
                if(j == 0 && t34[k] == 1 && t34[k + 1] == 0 && t34[k + 2] == 0){ t34[k] -= 1; koritsu[k] += 1; }
                if(j == 1 && t34[k - 1] == 0 && t34[k] == 1 && t34[k + 1] == 0 && t34[k + 2] == 0){ t34[k] -= 1; koritsu[k] += 1; }
                if((j >= 2 && j <= 6) && t34[k - 2] == 0 && t34[k - 1] == 0 && t34[k] == 1 && t34[k + 1] == 0 && t34[k + 2] == 0){ t34[k] -= 1; koritsu[k] += 1; }
                if(j == 7 && t34[k - 2] == 0 && t34[k - 1] == 0 && t34[k] == 1 && t34[k + 1] == 0){ t34[k] -= 1; koritsu[k] += 1; }
                if(j == 8 && t34[k - 2] == 0 && t34[k - 1] == 0 && t34[k] == 1){ t34[k] -= 1; koritsu[k] += 1; }
            }
        }
            //字牌
        for(i = 0; i < 7; i++){
            k = 27 + i;
            if(t34[k] == 1){
                t34[k] -= 1;
                koritsu[k] += 1;
            }
        }
        tr(koritsu);
        //シャンテン数ベースで手牌をきる,再帰
    }
    
    private function to34():Array {
        var retArr:Array = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
        var l:int = _tehai.length;
        for (var i:int = 0; i < l; i++) {
            retArr[_tehai[i]] += 1;
        }
        return retArr;
    }
    
    public function toString():String{
        return _tehai.toString();
    }
}