/**
 * Copyright kimo0517 ( http://wonderfl.net/user/kimo0517 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gq8t
 */

// forked from Antonio.Camacho's forked from: forked from: forked from: 【AS100本ノック】9回目：雪
// forked from kimo0517's forked from: forked from: 【AS100本ノック】9回目：雪
// forked from mex_ny's forked from: 【AS100本ノック】9回目：雪
// forked from mex's 【AS100本ノック】9回目：雪
/* 
 * AS100本ノック
 * 9回目のお題は「雪」
 * あなたなりの「雪」を表現してください。
 * 
 * 時間がないのでパラメータとかテキトーになた。
 */
package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.events.Event;

    public class Snow extends Sprite {
        private const SNOW_PARTICLE_NUMBER:uint = 30;
        private var _stageWidht:Number , _stageHeight:Number;
        
        private var snowArray:Vector.<SnowParticle>;

        public function Snow() {
            if ( stage ) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.MEDIUM;
            _stageWidht = stage.stageWidth;
            _stageHeight = stage.stageHeight;
            Wonderfl.capture_delay( 100 );
            
            addBackground();
            addSnow();
            changeDepth()
            addEventListener(Event.ENTER_FRAME, _updateAllSnow);
        }
        
        private function addBackground():void
        {
            var shape:Shape , g:Graphics;
            addChild( shape = new Shape() );
            g = shape.graphics;
            g.beginFill( 0x000000 );
            g.drawRect( 0 , 0 , _stageWidht , _stageHeight );
            g.endFill();
        }
        
        private function addSnow():void
        {
            var i:uint , snowParticle:SnowParticle;
            snowArray = new Vector.<SnowParticle>(SNOW_PARTICLE_NUMBER);
            
            for ( i = 1; i <= SNOW_PARTICLE_NUMBER; i++ )
            {
                addChild( snowParticle = new SnowParticle( _stageWidht , _stageHeight ) );
                snowParticle.name = i.toString();
                snowArray[i-1] = snowParticle;
            }
        }
        
        private function changeDepth():void
        {
            var i:uint , snowParticle:SnowParticle;

            for ( i = 1; i <= SNOW_PARTICLE_NUMBER; i++ )
            {
                snowParticle = getChildByName( i.toString() ) as SnowParticle;
                if ( snowParticle.isBig )
                    swapChildrenAt( getChildIndex(snowParticle ) , numChildren - 1 );
            }
        }
        
        private function _updateAllSnow(e:Event):void {
            var i:int;
            for ( i = 0; i < SNOW_PARTICLE_NUMBER; i++ )
            {
                snowArray[i].enterFrameHandler(null);
            }

        }

    }
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.Graphics;
import flash.events.Event;
import flash.filters.BlurFilter;
    
class SnowParticle extends Sprite
{
    private const PARTICLE_MAX_SIZE:uint = 50;
    private const MAX_SPPED:uint = 3;

    private var _countDownToAddSnow:int;
    private var _particle:Shape;
    private var _size:Number;
    private var _stageWidth:uint;
    private var _stageHeight:uint;
    private var _sx:Number;
    private var _sy:Number;
    private var _isBig:Boolean = false;
    private var _basePosition:Number;

    public function SnowParticle( stageWidth:uint , stageHeight:uint ):void
    {
        _stageWidth = stageWidth;
        _stageHeight = stageHeight;
        init();
    }
    
    private function init():void
    {
        checkBig();
        addSnow();
        setPosition();
        setSpeed();
        setFilter();
        moveSnow();
    }
    
    private function checkBig():void
    {
        if ( Math.round( Math.random() * 10 ) == 10 )
            _isBig = false;
    }
    
    private function addSnow():void
    {
        var g:Graphics , i:uint , pi:Number , angle:Number;
        
        addChild( _particle = new Shape() );
        
        if ( !_isBig )
        {
            _size = Math.random() * PARTICLE_MAX_SIZE / 10;
            _particle.alpha = _size / ( PARTICLE_MAX_SIZE / 10 ) * Math.random() + 0.3;
        }
        else
        {
            _size = Math.random() * PARTICLE_MAX_SIZE + PARTICLE_MAX_SIZE / 4;
            _particle.alpha = Math.random() * 0.7 + 0.2;
        }

        g = _particle.graphics;
        g.beginFill( 0xffffff );
        g.moveTo( _size , 0 );
        
        pi = Math.PI / 180;
        for( i = 0; i < 6;i++)
        {
            angle = 60 * i;
            g.lineTo( _size * Math.cos( pi * angle ) , _size * Math.sin( pi * angle ) );
        }
        g.lineTo( _size , 0);
    }
    
    private function setPosition():void
    {
        _particle.x = Math.random() * _stageWidth;
        _particle.y = Math.random() * _stageHeight * -1;
        
        //_basePosition = _size >> 1;
        _basePosition = _size / 2;
    }
    
    private function setSpeed():void
    {
        var speedY:Number;
        
        if( !_isBig )
            speedY = Math.random() * MAX_SPPED +  + ( MAX_SPPED >> 1 );
        else
            speedY = Math.random() * MAX_SPPED * 6 + ( MAX_SPPED >> 1 );
        _sy = speedY;
        _sx = ( Math.random() * 1 < 0.6 ) ? Math.random() * ( MAX_SPPED >> 1 ) : Math.random() * ( MAX_SPPED >> 1 ) * -1;
    }
    
    private function setFilter():void
    {
        return;
        if( !_isBig )
            _particle.filters = [ new BlurFilter( _size << 1 , _size << 1 ) ];
        else
            _particle.filters = [ new BlurFilter( 32 , 32 ) ];
    }

    private function moveSnow():void
    {
        //_particle.addEventListener( Event.ENTER_FRAME , enterFrameHandler );
    }
    
    public function enterFrameHandler( $evt:Event ):void
    {
        _particle.scaleX = _particle.scaleY = Math.random() * 0.05 + 0.95;
        //if ( _particle.scaleX > 1 ) _particle.scaleX = _particle.scaleY = 1;

        _particle.x += _sx;
        _particle.y += _sy;
        
        if ( _particle.y - _basePosition > _stageHeight || _particle.x + _basePosition < 0 || _particle.x - _basePosition > _stageWidth )
        {
            setPosition();
            setSpeed();
            setFilter();
        }
    }
    
    public function get isBig():Boolean { return _isBig; }
}