/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gpsS
 */

// forked from Bruce_Jawn's Bitmap Fonts
// ...cleaned/debugged a bit and made it more 'usable'...
// @Hasufel 2012

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.LoaderContext;

    [SWF(width="465", height="465", frameRate="60", backgroundColor="0")]

    public class BitmapFontExample extends Sprite {
        private var _myLoader:Loader = new Loader();
        private var _bitmapFont:BitmapFont;

        public function BitmapFontExample():void {
            stage?init():addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void {
            if (e) removeEventListener(Event.ADDED_TO_STAGE, init);
            addChild(new Bitmap(new BitmapData(465,465,false,0x0)));
            _myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaderReady);
            _myLoader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/6/65/6571/65713466b71e3a9cac8ddde8d74dbb13bc8f59de"),new LoaderContext(true));
        }
        
        private function onLoaderReady(e:Event):void {
            _bitmapFont = new BitmapFont((e.target.content).bitmapData,16,16,11,0x00000000);
            addChild(new Bitmap(_bitmapFont.returnBitmapText('\n\n\n"The young specialist in English Lit, ... lectured me severely\non the fact that in every century people have thought\nthey understood the Universe at last, and in every century\nthey were proved to be wrong.\nIt follows that the one thing we can say about\nour modern "knowledge" is that it is wrong.\n\n... My answer to him was,\n"... when people thought the Earth was flat,\nthey were wrong.\nWhen people thought the Earth was spherical\nthey were wrong.\nBut if you think that thinking\nthe Earth is spherical is just as wrong\nas thinking the Earth is flat,\nthen your view is wronger than both of them\nput together.""\n\n\n Isaac Asimov')));
        }
    }
}

import flash.display.*;
import flash.geom.*;

    class BitmapFont extends Sprite {
        public var _subDivisionsW:uint;
        public var _subDivisionsH:uint;
        public var _fontSize:uint;
        public var _bgColor:uint;
        private var _inputData:BitmapData;
        private var _fontChars:Vector.<Object> = new Vector.<Object>(256,true);

        public function BitmapFont(im:BitmapData,sdw:uint,sdh:uint,fs:uint,bg:uint):void {
            _inputData = im;
            _subDivisionsW = sdw;
            _subDivisionsH = sdw;
            _fontSize = fs;
            _bgColor = bg;
            initFontEngine();
        }

        public function initFontEngine():void {
            var rows:uint,cols:uint,pCol:int,pRow:int,pX:uint,pY:uint,currentChar:int = 0;
            var cellW:uint = _inputData.width / _subDivisionsW;
            var cellH:uint = _inputData.height / _subDivisionsH;
            var top:uint = cellH + cellH/2;
            var baseA:uint = cellH;

            for (rows = 0; rows < _subDivisionsW; ++rows) {
                for (cols = 0; cols < _subDivisionsH; ++cols) {
                    _fontChars[currentChar]={};
                    _fontChars[currentChar].y = cellH * rows;
                    _fontChars[currentChar].h = cellH;
                    for (pCol = 0; pCol < cellW; ++pCol) {
                        for (pRow = 0; pRow < cellH; ++pRow) {
                            pX = cellW * cols + pCol;
                            pY = cellH * rows + pRow;
                            if (_inputData.getPixel32(pX, pY) != _bgColor) {
                                _fontChars[currentChar].x = pX;
                                pCol = cellW;
                                pRow = cellH;
                            }
                        }
                    }
                    for (var pCol_w:int = cellW - 1; pCol_w > -1; --pCol_w) {
                        for (var pRow_w:int = 0; pRow_w < cellH; ++pRow_w) {
                           pX = cellW * cols + pCol_w;
                           pY = cellH * rows + pRow_w;
                            if (_inputData.getPixel32(pX, pY)!= _bgColor) {
                                _fontChars[currentChar].w = (pX - _fontChars[currentChar].x) + 1;
                                pCol_w = -1;
                                pRow_w = cellH;
                            }
                        }
                    }
                    for (pRow = 0; pRow < cellH; ++pRow) {
                        for (pCol = 0; pCol < cellW; ++pCol) {
                            pX = cellW * cols + pCol;
                            pY = cellH * rows + pRow;
                            if (_inputData.getPixel32(pX, pY)!= _bgColor) {
                                if (pRow < top) top = pRow;
                                pCol = cellW;
                                pRow = cellH;
                            }
                        }
                    }
                    if (currentChar == int('A')) {
                        for (pRow = cellH - 1; pRow > -1; --pRow) {
                            for (pCol = 0; pCol < cellW; ++pCol) {
                                pX = cellW * cols + pCol;
                                pY = cellH * rows + pRow;
                                if (_inputData.getPixel( pX, pY) != _bgColor) {
                                    baseA = pRow;
                                    pCol = cellW;
                                    pRow = -1;
                                }
                            }
                        }
                    }
                    currentChar++;
                }
            }
            for (var t:int = 0; t < _subDivisionsW*_subDivisionsH; ++t) {
                _fontChars[t].y += top;
                _fontChars[t].h -= top;
            }
        }

        public function returnBitmapText(st:String):BitmapData {
            var t:Array = st.split('');
            var X:uint=0,Y:uint=0,ascii:uint,i:uint,mw:uint=0,mh:uint=_fontSize,bw:uint,bh:uint=_fontSize,sp:uint=_fontSize/2;
            var tl:uint = t.length;
            //first, calculate bitmap dimensions
            for (i=0; i<tl; ++i) {
                if (t[i] == ' ') {
                    bw+=sp;
                    if (mw<bw) mw=bw;
                }
                else if (t[i] == '\n') {
                    bh+= _fontSize+sp;
                    if (mh<bh) mh=bh;
                }
                else {
                    bw+=_fontChars[t[i].charCodeAt(0)].w;
                    if (mw<bw) mw=bw;
                }
            }
            mw+=tl-1; //adjustment for padding
            var out:BitmapData = new BitmapData(mw,mh,true,0x00000000);
            for (var s:uint = 0; s<tl; ++s) {
                if (t[s] == ' ') X += sp;
                else if (t[s] == '\n') {
                    Y += _fontSize+sp;
                    X = 0;
                }
                else {
                    ascii = t[s].charCodeAt(0);
                    out.copyPixels(_inputData, new Rectangle(_fontChars[ascii>>0].x, _fontChars[ascii>>0].y, _fontChars[ascii>>0].w, _fontChars[ascii>>0].h), new Point(X,Y));
                    X += _fontChars[ascii>>0].w + 1;
                }
            }
            //out.threshold (out, out.rect,new Point(), "==", _bgColor); //if not using alpha, uncomment this line - and you can change as well getpixel32 to getpixel.
            return(out);
        }
    }

