/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gpms
 */

package {
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.primitives.Plane;
    
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DropShadowFilter;
    
    import gs.TweenLite;
    
    import flash.geom.Point;
    import flash.display.*;
    import flash.events.*;
    
    
    [SWF(backgroundColor="#DDDDDD", width="465", height="465", frameRate="60")]
    public class Cadre extends Sprite {
        
        private var rootContainer:Object3DContainer;
        private var cadre:Object3DContainer;
        private var camera:Camera3D;
        private var p2:Plane;
        private var shape:Shape;
        private var matrix:Array;
        private var bitmapData:BitmapData;
        private var filter:ColorMatrixFilter;
        
        public function Cadre() { 
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            rootContainer = new BSPContainer();
            
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            camera.rotationX = -120*Math.PI/180;
            camera.y = -500;
            camera.z = 300;
            rootContainer.addChild(camera);
            
            bitmapData = new BitmapData(270,270, true, 0x00000000);

            shape = new Shape();
            matrix = new Array();
            matrix = matrix.concat([0.7, 0, 0, 0, 0]);  // red
            matrix = matrix.concat([0, 0.8, 0, 0, 0]);  // green
            matrix = matrix.concat([0, 0, 0.8, 0, 0]);  // blue
            matrix = matrix.concat([0, 0, 0, 0.9, 0]);  // alpha
            filter = new ColorMatrixFilter( matrix );
            
            cadre = makeCadre();
            rootContainer.addChild(cadre);
            
            cadre.filters = [ new DropShadowFilter(0, 0, 0, .2, 8, 8, 1) ];
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void { 
            var tile_size:int = 30;
            var x: int = Math.floor(Math.random()*270/tile_size)*tile_size;
            var y: int = Math.floor(Math.random()*270/tile_size)*tile_size;
            
            shape.graphics.clear();
            shape.graphics.beginFill(0xFFFFFF);
            shape.graphics.drawRect(x,y,tile_size,tile_size);  
            shape.graphics.endFill();
            
            bitmapData.draw(shape);
            bitmapData.applyFilter( bitmapData, bitmapData.rect, new Point(),filter );

            camera.render();
        }

        private function onMove(e:MouseEvent):void {
            TweenLite.to(camera, 1, {y:-500+(e.stageY/stage.stageHeight)*100});
            TweenLite.to( cadre, 1, {rotationZ : (e.stageX/stage.stageWidth)*Math.PI/2-Math.PI/4});
        }
        
        private function makeCadre():Object3DContainer {
            var p:Plane = new Plane(300,300);
            p.setMaterialToAllFaces(new FillMaterial(0xFFFFFF));
            
            p2 = new Plane(270,270);
            p2.setMaterialToAllFaces( new TextureMaterial(bitmapData));
            p2.z = 5;
            
            var cadre:BSPContainer = new BSPContainer();
            cadre.addChild( p );
            cadre.addChild( p2 );
            cadre.rotationX = Math.PI/2.5;
            return cadre;
        }
    }
}