/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gpZQ
 */

// -------------------------------------------------
//
// 同心円状に回転させるフィルタ
// 
// …という日本語が正しいのかよくわかりませんが回ります。
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;
	import flash.media.*;

    public class Main extends Sprite {
        public function Main() {



// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// ビデオを配置
var video_obj : Video = new Video();
addChild(video_obj);

// ストリーム
var connection:NetConnection = new NetConnection();
connection.connect(null);	
var netStream:NetStream = new NetStream(connection);

// ビデオとストリームを関連付け
video_obj.attachNetStream(netStream);

// メタデータ取得
var obj:Object = new Object();
obj.onMetaData = function(param:Object):void{
}
netStream.client = obj;

// リソース読み込み開始
load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	// 動画のURL
	var movie_url:String = "http://actionscript.web.officelive.com/wonderfl/movie000.mp4";

	// サウンドをOFF
	var trans : SoundTransform = netStream.soundTransform;
	trans.volume = 0.0;
	netStream.soundTransform = trans;

	// 再生開始
	netStream.play(movie_url);

	// 初期化へ
	init();
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint;
	var h:uint;
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		video_obj.width = w;
		video_obj.height = h;
	}
	ResizeFunc(null);

	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;

	// パラメータ
	var rotate:Number = 0;	// 角度
	var radius:Number = 5;	// 半径
	
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{

		// 少し回転
		rotate += 1;
		if(rotate > 360)	rotate -= 360;
		
		//  中心位置
		param = data.position;
		param.value = [mouseX , mouseY];

		// 角度
		param = data.rotate;
		param.value = [rotate];

		// 半径
		param = data.radius;
		param.value = [radius];

		// 適応
		video_obj.filters = [filter];
	});

	// テキスト表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 300;
	tf.height = 20;
	tf.border = true;
	tf.background = true;
	tf.alpha = 0.9;
	
	// 書式
	var format : TextFormat = new TextFormat();
	format.font = "ＭＳ ゴシック";
	tf.defaultTextFormat = format;

	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "半径:" + radius + "　(上下キーで変更)\n";

		tf.text = str;
	});
	
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == Keyboard.UP)	radius -= 1;
		if(event.keyCode == Keyboard.DOWN)	radius += 1;

		
		if(radius < 0.0)	radius = 0.0;
	};

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a41c00); f(0x436f6e63); f(0x656e7472); 
	f(0x69634369); f(0x72636c65); f(0x526f7461); f(0x74654669); 
	f(0x6c746572); f(0xa00c6e61); f(0x6d657370); f(0x61636500); 
	f(0x636f6e63); f(0x656e7472); f(0x69632063); f(0x6972636c); 
	f(0x6520726f); f(0x74617465); f(0x00a00c76); f(0x656e646f); 
	f(0x72004861); f(0x6b756869); f(0x6e00a008); f(0x76657273); 
	f(0x696f6e00); f(0x0100a00c); f(0x64657363); f(0x72697074); 
	f(0x696f6e00); f(0x93af9053); f(0x897e8ff3); f(0x82c989f1); 
	f(0x935d82b3); f(0x82b982e9); f(0x83748342); f(0x838b835e); 
	f(0x00a10102); f(0x00000c5f); f(0x4f757443); f(0x6f6f7264); 
	f(0x00a30004); f(0x73726300); f(0xa1020401); f(0x000f6473); 
	f(0x7400a101); f(0x02000003); f(0x706f7369); f(0x74696f6e); 
	f(0x00a20264); f(0x65666175); f(0x6c745661); f(0x6c756500); 
	f(0x43480000); f(0x43160000); f(0xa20c6465); f(0x73637269); 
	f(0x7074696f); f(0x6e00897e); f(0x82cc9286); f(0x90538dc0); 
	f(0x955700a1); f(0x01010200); f(0x08726164); f(0x69757300); 
	f(0xa2016d69); f(0x6e56616c); f(0x7565003f); f(0x800000a2); 
	f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65004120); 
	f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
	f(0x94bc8c61); f(0x00a10101); f(0x02000472); f(0x6f746174); 
	f(0x6500a201); f(0x6d696e56); f(0x616c7565); f(0x00000000); 
	f(0x00a2016d); f(0x61785661); f(0x6c756500); f(0x43b40000); 
	f(0xa2016465); f(0x6661756c); f(0x7456616c); f(0x75650000); 
	f(0x000000a2); f(0x0c646573); f(0x63726970); f(0x74696f6e); 
	f(0x008a7093); f(0x78001d02); f(0x00310000); f(0x10001d03); 
	f(0x00200200); f(0x80000203); f(0x00200000); f(0x80001d03); 
	f(0x00800300); f(0x80001d03); f(0x00200200); f(0xc0000203); 
	f(0x00200000); f(0xc0001d03); f(0x00400300); f(0x80001d03); 
	f(0x00310300); f(0x10001d03); f(0x00800300); f(0xc0000603); 
	f(0x00800300); f(0x80001d03); f(0x00400300); f(0x00001d03); 
	f(0x00800300); f(0x80000303); f(0x00800300); f(0x80001d04); 
	f(0x00800300); f(0xc0000304); f(0x00800300); f(0xc0001d04); 
	f(0x00400300); f(0x00000104); f(0x00400400); f(0x00001603); 
	f(0x00800400); f(0x40001d04); f(0x00800300); f(0x00000403); 
	f(0x00800200); f(0x00000303); f(0x00800400); f(0x00001a04); 
	f(0x00400300); f(0x00001d03); f(0x00800400); f(0x40003204); 
	f(0x00404000); f(0x00001d04); f(0x00200300); f(0x00000804); 
	f(0x00200400); f(0x40001e01); f(0x80800400); f(0x80003201); 
	f(0x80400000); f(0x00002801); f(0x80800180); f(0x40001d01); 
	f(0x80200080); f(0x00003400); f(0x00000180); f(0x80003204); 
	f(0x00403c8e); f(0xfa350304); f(0x00400200); f(0x40000103); 
	f(0x00400400); f(0x40003500); f(0x00000000); f(0x00003204); 
	f(0x00403c8e); f(0xfa350304); f(0x00400200); f(0x40000203); 
	f(0x00400400); f(0x40003600); f(0x00000000); f(0x00000d04); 
	f(0x00400300); f(0x40001d04); f(0x00200400); f(0x40000304); 
	f(0x00200400); f(0x00001d04); f(0x00400000); f(0x80000104); 
	f(0x00400400); f(0x80001d02); f(0x00200400); f(0x40000c04); 
	f(0x00400300); f(0x40001d04); f(0x00200400); f(0x40000304); 
	f(0x00200400); f(0x00001d04); f(0x00400000); f(0xc0000104); 
	f(0x00400400); f(0x80001d02); f(0x00100400); f(0x40003105); 
	f(0x00f10200); f(0xb0001d01); f(0x00f30500); 

	f = a.writeShort;
	f(0x1b00); 

	return a;
}


            
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	position		円の中心座標
	radius			半径
	rotate			角度
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel ConcentricCircleRotateFilter<
	namespace : "concentric circle rotate";
	vendor : "Hakuhin";
	version : 1;
	description : "同心円状に回転させるフィルタ";
>{
	input image4 src;	// 入力イメージ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float2 position<
		defaultValue:float2(200.0 , 150.0);
		description : "円の中心座標";
	>;
	parameter float radius<
		minValue:float(1.0);
		defaultValue:float(10.0);
		description : "半径";
	>;
	parameter float rotate<
		minValue:float(0.0);
		maxValue:float(360.0);
		defaultValue:float(0);
		description : "角度";
	>;


	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){
		// ピクセルの位置を取得
		float2 pos = outCoord();

		// 中心座標から位置までのベクトルを取得
		float2 v = float2(pos.x - position.x,pos.y - position.y);

		// ベクトルからラジアンを取得
		float rad = atan(v.y , v.x);

		// ベクトルから長さを求める
		float distance = sqrt((v.x * v.x) + (v.y * v.y));
		
		// 周期に丸める
		float d = floor(distance / radius);
		
		// 回転方向を調べる
		if(int(mod(d,2.0)) == 0)    rad += radians(rotate);
		else                        rad -= radians(rotate);

		// オフセットを取得して座標にセット
		pos.x = position.x + cos(rad) * distance;
		pos.y = position.y + sin(rad) * distance;

		// ソースイメージからピクセルカラーを取得して出力
		dst = sampleLinear(src,pos);
	}
}
*/



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	
	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}