/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gpBf
 */

package 
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import net.hires.debug.Stats;
    
    /**
    * Name           : Main
    * Coded By      : Matt Wakeling
    * Date           : 26th April 2012
    * Description    : Main Extry Point
    *
    * @author Matt Wakeling
    */
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite 
    {
        // Main Constructor
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        // init Method
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            
            var scrEqualiser:Equalizer = new Equalizer;
            scrEqualiser.y = 75;
            scrEqualiser.width = stage.stageWidth;
            addChild(scrEqualiser);
           
            addChild(new Stats());           
           
        }
        
    }
    
}


    // Import External Classes
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.PixelSnapping;
    
    /**
    * Name           : Equalizer 
    * Coded By      : Matt Wakeling
    * Date           : 26th April 2012
    * Description    : Flash Spectrum Equalizer with Mirror Effect. 
    *                 : MP3 Music borrowed from the hycro visualizer wonderfl source.
    *
    * @author Matt Wakeling
    */
    class Equalizer extends Sprite
    {
        // Intialise Class Properties        
        private var numRectangleWidth:Number     = 2.734375;
        private var uintRectangleHeight:uint     = 200;
        
        private var MP3Sound:Sound                = new Sound;
        private var MP3Channel:SoundChannel;
        private var MP3ByteArray:ByteArray         = new ByteArray();
        private var uintMP3ChannelSize:uint        = 256;
        
        private var bdMirrorImage:BitmapData    = new BitmapData(700, uintRectangleHeight, true, 0x00000000);
        private var bmpMirrorImage:Bitmap        = new Bitmap(bdMirrorImage, PixelSnapping.AUTO, true);
        
        private var matBlendMatrix:Matrix         = new Matrix();
        private var arrBlendColors:Array         = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF, 0xFF0000];
        private var arrBlendLeftAlphas:Array     = [1, 1, 1, 1, 1, 1, 1];
        private var arrBlendRightAlphas:Array     = [0.5,0.5,0.5,0.5,0.5,0.5,0.5];
        private var arrBlendRatios:Array         = [0, 42, 84, 126, 168, 210, 255];
            
        private var matMirrorMatrix:Matrix         = new Matrix(1, 0, 0, -1, 0, uintRectangleHeight);
        
        // Equalizer Constructor
        public function Equalizer()
        {
            MP3Sound.load(new URLRequest("http://hycro.crz.jp/wonderfl/sound/u-chi-u.mp3"), new SoundLoaderContext(10000, true));
        
            
            matBlendMatrix.createGradientBox(numRectangleWidth, uintRectangleHeight, ((-90 * Math.PI) / 180));
                        
            bmpMirrorImage.x         = 0;
            bmpMirrorImage.y         = uintRectangleHeight;
            bmpMirrorImage.scaleY     = 0.5;
            bmpMirrorImage.alpha     = 0.5;
            
            addChild(bmpMirrorImage);
            
            MP3Channel = MP3Sound.play(0,0);
            MP3Channel.addEventListener(Event.SOUND_COMPLETE, evtMP3Repeat);
            
            addEventListener(Event.ENTER_FRAME, evtEqualizer);    
        }
        
        // evtEqualizer Method
        private function evtEqualizer(event:Event):void
        {
            var numFrequency:Number         = 0;
            
            SoundMixer.computeSpectrum(MP3ByteArray);
            
            this.graphics.clear();
            
            for (var uintLeftCount:uint = 0; uintLeftCount < uintMP3ChannelSize; uintLeftCount++)
            {
                numFrequency = Math.abs(MP3ByteArray.readFloat());
                
                this.graphics.lineStyle();
                this.graphics.beginGradientFill(GradientType.LINEAR, arrBlendColors, arrBlendLeftAlphas, arrBlendRatios, matBlendMatrix, SpreadMethod.REPEAT);
                this.graphics.drawRect((uintLeftCount * numRectangleWidth), uintRectangleHeight, Math.floor(numRectangleWidth), -(numFrequency * uintRectangleHeight));
                this.graphics.endFill();
            }
            
            for (var uintRightCount:uint = 0; uintRightCount < uintMP3ChannelSize; uintRightCount++)
            {
                numFrequency = Math.abs(MP3ByteArray.readFloat());
                
                this.graphics.lineStyle();
                this.graphics.beginGradientFill(GradientType.LINEAR, arrBlendColors, arrBlendRightAlphas, arrBlendRatios, matBlendMatrix, SpreadMethod.REPEAT);
                this.graphics.drawRect((uintRightCount * numRectangleWidth), uintRectangleHeight, Math.floor(numRectangleWidth), -(numFrequency * uintRectangleHeight));
                this.graphics.endFill();
            }
            
            
            bdMirrorImage.lock();
            bdMirrorImage.fillRect(bdMirrorImage.rect, 0x00000000);
            bdMirrorImage.draw(this, matMirrorMatrix, null, null, null, true);
            bdMirrorImage.unlock();
        }
        
        // evtMP3Repeat Method
        private function evtMP3Repeat(e:Event):void
        {
            MP3Channel = MP3Sound.play(0,0);
            MP3Channel.addEventListener(Event.SOUND_COMPLETE, evtMP3Repeat);
        }
    
    }


