/**
 * Copyright aiaigasa1122 ( http://wonderfl.net/user/aiaigasa1122 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gop3
 */

package
{
    import Box2D.Collision.Shapes.b2MassData;
    import Box2D.Collision.Shapes.b2PolygonShape;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2FixtureDef;
    import Box2D.Dynamics.b2World;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    [SWF(backgroundColor="#666666", width="400", height="400")]
    public class testBox2D_02 extends Sprite
    {
        private const SCALE:Number = 10.0;
        private var world:b2World;
        
        public function testBox2D_02()
        {    
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            // メッセージとクリック時の処理
            var count:int = 0;
            var tf:TextField = new TextField();
            tf.textColor = 0xffffff;
            tf.text = "click to start";
            addChild( tf );
            var animation:Boolean = false;
            stage.addEventListener( "click", function( event:Event ):void{
                    count = 0;
                    animation = !animation;
                    tf.text = "Click to " + (animation ? "stop" : "start" );
            });
                
            // 初期化
            init();
            createObject();

            // 毎フレームの処理
            count = 0;
            addEventListener( Event.ENTER_FRAME , function(event:Event):void {
                world.Step( 1 / 10, 6,  2);
                if (count == 0 && animation){
                    createObject();
                }
                count = (count + 1) % 30;
                
                // 下に行ったオブジェクトを削除する
                for (var b:b2Body = world.GetBodyList(); b; b = b.GetNext()) {
                    if (b.GetWorldCenter().y * SCALE > 600){
                        world.DestroyBody(b);
                    }
                }
                
                world.ClearForces();
                world.DrawDebugData();
            });
        }
        
        private function createObject():void{
            // 物体の定義を作成
            var objBdDef:b2BodyDef = new b2BodyDef();
            objBdDef.position.Set( ( 300 * Math.random() ) / SCALE, 0 );
            objBdDef.angle  = Math.PI / 2 * Math.random();
            objBdDef.type = b2Body.b2_dynamicBody;
            
            // 物体を作成
            var objBd:b2Body = world.CreateBody( objBdDef );
            
            // 形の定義を作成
            var shapeDef:b2PolygonShape = new b2PolygonShape();
            shapeDef.SetAsBox( 30 / SCALE, 30 / SCALE );
            var shapeFixDef:b2FixtureDef = new b2FixtureDef();
            shapeFixDef.shape = shapeDef;
            shapeFixDef.density = 1.0;
            shapeFixDef.restitution = 0.3;
            shapeFixDef.friction = 0.01;
            
            // 形を物体に追加
            objBd.CreateFixture( shapeFixDef );
            
            // 定義を変更してもう一個の形を追加
            shapeDef.SetAsBox( 40 / SCALE, 5 / SCALE );
            shapeFixDef.shape = shapeDef;
            objBd.CreateFixture( shapeFixDef );
            
        }
        
        private function init():void
        {
            world = new b2World( new b2Vec2( 0, 10.0 ), true );
            
            //-------
            //    床の作成
            
            //    1. 物体の定義を作る
            var wallBdDef:b2BodyDef = new b2BodyDef();
            wallBdDef.position.Set( 400 / SCALE / 2, 300 / SCALE );
            wallBdDef.angle = Math.PI / 24;
                
            //    2. 物体を作る
            var wallBd:b2Body = world.CreateBody( wallBdDef );
            
            //    3. 形の定義を作成
            var wallShapeDef:b2PolygonShape = new b2PolygonShape();
            wallShapeDef.SetAsBox( 180 / SCALE, 10 / SCALE );
            
            //    4 形を物体に追加
            var wallFixdef:b2FixtureDef = new b2FixtureDef();
            wallFixdef.shape = wallShapeDef;
            wallFixdef.density =1.0;
            wallFixdef.friction = 1.0;
            wallBd.CreateFixture( wallFixdef );
            
            //    debug draw を有効
            var d_sprite:Sprite = new Sprite();
            addChild( d_sprite );
            var debugdraw:b2DebugDraw = new b2DebugDraw();
            debugdraw.SetSprite( d_sprite );
            debugdraw.SetDrawScale( SCALE );
            debugdraw.SetLineThickness( 1 );
            debugdraw.SetAlpha( 1 );
            debugdraw.SetFillAlpha( 0.4 );
            debugdraw.SetFlags( b2DebugDraw.e_shapeBit );
            world.SetDebugDraw( debugdraw );
            
        }
    }
}