/**
 * Copyright nogud ( http://wonderfl.net/user/nogud )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gojm
 */

// forked from kamipoo's こういうのなんて言うんだっけ？
package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;
    
    import net.hires.debug.Stats;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(frameRate="60")]
    
    public class Test extends Sprite
    {
        
        private var _terminals:Array = [];
        
        public function Test()
        {
            super();
            
            //Wonderfl.capture_delay( 5 );
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.addChild(new Stats());
            
            _init();
        }
        
        private function _init():void
        {
            _initTerminals();
            
            addEventListener(Event.ENTER_FRAME, _enterframeHandler);
        }
        
        private function _initTerminals():void
        {
            _terminals = [];
            for(var i:int = 0, l:int = 40; i < l; i++) {
                var p:Particle = new Particle();
                p.x = Math.random() * stage.stageWidth;
                p.y = Math.random() * stage.stageHeight;
                _terminals[_terminals.length] = addChild(p);
                var ii:int = 10;
                var tweens:Array = [];
                while(ii--) tweens[tweens.length] = BetweenAS3.to(p, {x: Math.random() * stage.stageWidth, y: Math.random() * stage.stageHeight}, Math.random()*4+10);
                tweens[tweens.length] = BetweenAS3.to(p, {x: p.x, y: p.y}, Math.random()*4+10);
                var t:ITween = BetweenAS3.serialTweens(tweens);
                t.stopOnComplete = false;
                t.play();
            }
        }
        
        private function _enterframeHandler(e:Event):void
        {
            var g:Graphics = graphics;
            g.clear();
            g.beginFill(0xffffff, 1);
            g.drawRect(0, 0, stage.stageWidth, stage.stageWidth);
            g.endFill();
            g.lineStyle(0, 0x6fb3ca, 1);
            
            for(var i:int = 0, l:int = _terminals.length; i < l; i++) {
                var parent:Particle = _terminals[i];
                parent.point.x = parent.x;
                parent.point.y = parent.y;
                for(var ii:int = i+1, ll:int = _terminals.length; ii < ll; ii++) {
                    if(i==ii) continue;
                    var target:Particle = _terminals[ii];
                    target.point.x = target.x;
                    target.point.y = target.y;
                    var dist:Number = Point.distance(parent.point, target.point);
                    if(dist < 200) {   
                        //g.beginFill(0x1d509f, 0.7);
                        g.moveTo(parent.x, parent.y);
                        g.lineTo(target.x, target.y);
                        //g.endFill();
                    }
                }
            }
        }
        
    }
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Point;

class Particle extends Shape {
    
    public var point:Point = new Point();
    
    public function Particle()
    {
        super();
        
        var g:Graphics = graphics;
        g.beginFill(0xFFFFFF, 1);
        g.drawCircle(0, 0, 0);
        g.endFill();
        
    }
}