/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gmzM
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.utils.getTimer
    [SWF(width=465, height=465,frameRate=30)] 
    public class Professional extends Sprite {
        private var g:Sprite;
        private var pattern:BitmapData
        private var bmd:BitmapData;
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            bmd = new BitmapData(480, 480, true)
            addChild(new Bitmap(bmd)) as Bitmap;
            pattern= sample1();

            
            g = new Sprite()
            addEventListener(Event.ENTER_FRAME,update)
        }
        private function update(e:Event):void {
            var a:Number = (getTimer() / 160)
            var mat:Matrix = new Matrix();
            mat.rotate(a * Math.PI / 180); 
            var matrix:Matrix = new Matrix()
            matrix.rotate(a * Math.PI / 180)
            matrix.translate(stage.stageWidth/2,stage.stageHeight/2)
            g.graphics.clear()
            g.graphics.beginBitmapFill(pattern, mat, true, false)
            g.graphics.drawRect(0, 0, 480, 480);
            g.graphics.endFill();
            bmd.draw(g, matrix)
        }
        //most simple patern
        public function sample1():BitmapData{
            return BitmapPatternBuilder.build(
                [[1,0],
                 [0,1]],
                [0xff000000, 0xffffffff]
            );
        }
     }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}