/**
 * Copyright sooochan ( http://wonderfl.net/user/sooochan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gmmS
 */

package 
{
    //画像に似非モザイクをかけるようなものをつくってみました。
    //バーでモザイクの数を変えられます。 
    import net.hires.debug.Stats;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.net.URLRequest;
    import caurina.transitions.Tweener;

    [SWF(width="465", height="465", backgroundColor="0x0")]
     
    public class MosaicMake extends Sprite 
    {
        private var bm:Bitmap;
        private var mosaic:MosaicMaker;
        private var seekBar:Sprite;
        private var f:FileReference;
        private var fileSelectBtn:Btn;
        private var tween:Function = Tweener.addTween;
        private var masterBM:Bitmap;
        private var _fileFilter:Array = [new FileFilter("ImagefileSelect","*.jpg;*.gif;,*.png;")]
                
        public function MosaicMake():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            fileSelectBtn = new Btn();
            fileSelectBtn.y = 420;
            fileSelectBtn.addEventListener(MouseEvent.MOUSE_UP, fileSelect);
            addChild(fileSelectBtn);
            
            addChild(new Stats());    
        }
        
        private function fileSelect(e:MouseEvent):void {
            e.currentTarget.removeEventListener(MouseEvent.MOUSE_UP, fileSelect);        

            if (mosaic) {
                 tween(mosaic, { alpha:0,time:1, onComplete:deleteMC});
            }
            
            f = new FileReference();
            f.addEventListener(Event.SELECT, selecter);
            f.browse(_fileFilter);
        }
        
        private function selecter(e:Event):void {
            f.removeEventListener(Event.SELECT, selecter);
            f.addEventListener(Event.COMPLETE, compe);
            f.load();
        }
        
        private function compe(e:Event):void {
            f.removeEventListener(Event.COMPLETE, compe);
            fileSelectBtn.addEventListener(MouseEvent.MOUSE_UP, fileSelect);
            
            var loader:Loader = new Loader();
            loader.loadBytes(f.data);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, comp);                    
        }

        private function comp(e:Event):void {
            e.target.removeEventListener(Event.COMPLETE, comp);
                        
            var l:Loader =     e.target.loader;
            
            var bitmap:BitmapData = new BitmapData(l.width, l.height);
            bitmap.draw(l);
            var bit:Bitmap = new Bitmap(bitmap);            
            var masterBM:Bitmap = checkBMP(bit)
            
            var barz:SeekBar = new SeekBar(0x0,this.stage.stageWidth,10);
            seekBar = barz.bar;
            barz.addEventListener(SeekBar.MOUSERUP, mouseUP);

            mosaic = new MosaicMaker(masterBM);
            mosaic.x = this.stage.stageWidth / 2 - masterBM.width / 2 + 50;
            mosaic.y = 10;
            
            addChild(mosaic);
            addChild(barz);
        }
        
        private function mouseUP(e:Event):void {
            
            var per:int = Math.floor((seekBar.x / this.stage.stageWidth) * 100);
            
            if (per < 10) {
                per = 10;
                mosaic.make(per);
            }else if (per > 80) {
                mosaic.base();
            }else{
                mosaic.make(per);
            }
        }
        
        private function checkBMP(_bm:Bitmap):Bitmap {
            var bm:Bitmap = _bm;
            var msBM:Bitmap;
            var master:BitmapData
            var max:Number = Math.max(bm.width, bm.height);
            
            if (max > 400) {
                var ratio:Number = 400 / max;                
                var mat:Matrix = new Matrix();
                mat.scale(ratio, ratio);            
                master = new BitmapData(bm.width * ratio, bm.height * ratio);
                master.draw(_bm, mat);
            }else {
                master = new BitmapData(bm.width, bm.height);
                master.draw(_bm);
            }
            
            masterBM = new Bitmap(master);
            return masterBM;
        }
        
        private function deleteMC():void {
            removeChild(mosaic);
        }
        
    }
    
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.geom.Matrix;
    
class MosaicMaker extends Sprite
{
    private var bm:Bitmap;
    private var bmd:BitmapData;
    private var bm_ar:Array;
    private var mo_num:int;
    private var master:BitmapData;
    private var canvas:BitmapData;
    
    public function MosaicMaker(_bm:Bitmap){
        bm = _bm;
        bm_ar = [];

        canvas = new BitmapData(_bm.width, _bm.height, false, 0xffffff);
        base();
    }
    
    public function make(_mo_num:int):void {
        
        bm_ar = [];
        mo_num = _mo_num;
        
        canvas.fillRect(canvas.rect, 0x0);
        
        var bm_height:Number = Math.ceil(bm.height / mo_num);
        var bm_width:Number = Math.ceil(bm.width / mo_num);
        
        for (var i:int = 0; i < mo_num; i++) {
            for (var n:int = 0; n < mo_num; n++) {
                
                var col:uint = bm.bitmapData.getPixel( i * bm_width, n * bm_height);
                var sp:Shape = new Shape();
                sp.graphics.beginFill(col);
                sp.graphics.drawRect( i * bm_width, n * bm_height, bm_width, bm_height);
                sp.graphics.endFill();
                bm_ar.push(sp);
            }
        }

        var t:int = mo_num * mo_num        
        while(t--){
            canvas.draw(bm_ar[t]);
        }
        
        addChild(new Bitmap(canvas));

    }
    
    public function base():void {
        canvas.fillRect(canvas.rect, 0xffffff);
        canvas.draw(bm);
        addChild(new Bitmap(canvas));
    }
}

import flash.display.Sprite
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;

class Btn extends Sprite {
    
    public function Btn() {
        var file_base:FileSelectBtn = new FileSelectBtn(100, 30);
        var tf:TextField = new TextField();
        addChild(file_base);
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.text = "FileSelect"
        tf.selectable = false;
        addChild(tf);
        tf.x = file_base.width / 2 - tf.width / 2
        tf.y = 5;
    }        
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.Event;

class SeekBar extends Sprite {
    private var bg:Shape;
    public var bar:Sprite;
    private var flg:Boolean;
    public static const MOUSERUP:String = "mouseUpp"
    public function SeekBar($color:uint,$width:Number,$height:Number) {
        
        bg = new Shape();
        bar = new Sprite();

        bg.graphics.beginFill(0xFFFFFF);
        bg.graphics.drawRect(0, 400, $width, $height);
        bg.graphics.endFill();
        
        bar.graphics.beginFill(0x272B04);
        bar.graphics.drawRect(50, 400, 30, $height);
        bar.graphics.endFill();

        addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
        addEventListener(MouseEvent.MOUSE_UP, upHandler);
        
        bar.useHandCursor = true;
        bar.buttonMode = true;
        
        addChild(bg);
        addChild(bar)
        
    }
    
    private function downHandler(e:MouseEvent):void {
        bar.x = this.stage.mouseX - bar.width * 2;
        flg = true;
        addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
    }
    
    private function moveHandler(e:MouseEvent):void {
        bar.x = this.stage.mouseX - bar.width * 2;
    }
    
    private function upHandler(e:MouseEvent):void {
        removeEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
        if(flg==true){
            dispatchEvent(new Event(MOUSERUP));
            flg = false;
        }
    }
}

import flash.display.Sprite;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.display.Shape;
import flash.text.TextFieldAutoSize;
import flash.utils.ByteArray;
    
class FileSelectBtn extends Sprite
{
    private var btn:Sprite;
    public function FileSelectBtn($width:Number,$height:Number) 
    {
        btn = new Sprite();
        btn.graphics.beginFill(0xFFFFFF);
        btn.graphics.drawRect(0, 0, $width, $height);
        btn.graphics.endFill();
    
        var line:Shape = new Shape();
        line.graphics.lineStyle(1, 0xCCCCCC, 1);
        line.graphics.moveTo(0, 0);
        line.graphics.lineTo($width, 0);
        line.graphics.lineTo($width, $height);
        line.graphics.lineTo(0, $height);
        line.graphics.lineTo(0, 0);

        btn.buttonMode = true;
        
        addChild(btn);
        addChild(line);
    
    }

}