/**
 * Copyright glasses_factory ( http://wonderfl.net/user/glasses_factory )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gmBS
 */

// forked from checkmate's Saqoosha challenge for amateurs
package
{	
	import __AS3__.vec.Vector;
	
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.utils.*;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.*;

        [SWF(backgroundColor = "0x000000")]
	public class Sample4 extends Sprite
	{
		public function Sample4()
		{
		    super();
                    init();
                    reset();
		    return;
		}
		
		public function init():void
		{
			var __reg1:*;
			var p:Particle;
			var i:int;
			var rr:int;
			var gg:int;
			var col:Number;
			var t:ITween;
			
			i = 0;
			rr = 0;
			gg = 0;
			col = NaN;
			grad = new Gradation(0xff0000,0xffff00,0x00ff00,0x00ffff,0x0000ff,0xff00ff);
			
			bmp = new Bitmap(bmd,"auto",false);
			addChild(bmp);
			
			particles = new Vector.<Particle>();
			i = 0;
			while(i < particleNum)
			{
				p = new Particle();
				p.x = p.fx = p.tempX = Math.random() * stage.stageWidth;
				p.y = p.fy = Math.random() * stage.stageHeight;
				rr = Math.min(Math.random() * 48 + 24,255);
				gg = Math.random() * rr;
				p.col = (rr << 16) + (rr << 8) + rr;
				
				p.t1 = BetweenAS3.tween(p,
									 {x:p.tempX,
									 y:stage.stageHeight},
									null, 1.5 * Math.random() * 4.5,
									 Back.easeInOut
									 );
				p.t1.stopOnComplete = false;
				p.t1.play();
				particles.push(p);
				i++;
			}
			tempColt = new ColorTransform();
			fadeColt = new ColorTransform(1,(1),(1),1, 0.5, 0.5, 0.5, 0);
			
			stage.addEventListener(Event.ENTER_FRAME,function(e:flash.events.Event):void
			{
				step();
				return;
			});
			stage.addEventListener(Event.RESIZE,function(e:flash.events.Event):void
			{
				reset();
				return;
			});
			return;
		}
		
		protected function step():void
		{
			var __reg1:*;
			var __reg2:*;
			var __reg3:*;
			var __reg4:*;
			var __reg5:*;
			var __reg6:*;
			var __reg7:*;
			var __reg8:*;
			var __reg9:*;
			var __reg10:*;
			var __reg11:*;
			2
			
			bmd.lock();
			bmd.colorTransform(bmd.rect,fadeColt);
			__reg1 = 0;
			while(__reg1 < particleNum)
			{
				__reg2 = Particle(particles[__reg1]);
				__reg3 = stage.mouseX - __reg2.x;
				__reg4 = stage.mouseY - __reg2.y;
				__reg5 = Math.sqrt(__reg3 * __reg3 + __reg4 * __reg4);
				
				__reg8 = bmd.getPixel(int(__reg2.x), int(__reg2.y));
				__reg9 = __reg2.col;
				__reg10 = __reg2.y / stage.stageHeight;
				__reg11 = grad.getColor(__reg10);
				
				if(__reg5 < 100)
				{
					__reg2.t1.stop();
					__reg6 = __reg3 / __reg5 * 250 / __reg5;
					__reg7 = __reg4 / __reg5 * 250 / __reg5;
					__reg2.vx = __reg2.vx * 0.9 + __reg6;
					__reg2.vy = __reg2.vy * 0.9 + __reg7;
					__reg2.x += (__reg2.fx - (__reg2.x + __reg2.vx)) * 1.5;
					__reg2.y += (__reg2.fy - (__reg2.y + __reg2.vy)) * 1.5;
				}
				else if(__reg5 > 100)
				{
					__reg2.t1.play();
				}
			
				bmd.setPixel(int(__reg2.x),int(__reg2.y),__reg11);
				__reg1++;
			}
			
			bmd.applyFilter(bmd,bmd.rect,new Point(0,(0)),new BlurFilter(4,(4),2));
			bmd.unlock();
			return;
		}
		
		public function reset():void
		{
			if(bmd)
			{
				bmd.dispose();
			}
			bmd = new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
			bmp.bitmapData = bmd;
			return;
		}
		
		protected var bmd:flash.display.BitmapData;
		protected var bmp:flash.display.Bitmap;
		protected var tempColt:flash.geom.ColorTransform;
		protected var fadeColt:flash.geom.ColorTransform;
		protected var particles:Vector.<Particle>;
		protected var tweens:Array;	
		protected var grad:Gradation;
		protected var tempPt:flash.geom.Point;
		protected const particleNum:Number = 8000;
	}
}

import org.libspark.betweenas3.tweens.ITween;
	
class Particle extends Object
{
	public function Particle()
	{
	    super();
	    return;
	}
	
	public var col:Number;
	public var x:Number = 0;
	public var y:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;	
	public var fx:Number = 0;
	public var fy:Number = 0;
        public var tempX:Number = 0;
	public var t1:ITween;
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}