/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gki8
 */

// forked from kotobuki's Gainer Basic Example: Button
// I/Oモジュール上のボタンを押す、離す、長押しすると画面上の
// 矩形が変化します。
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_Button extends Sprite {

        private var gio:Gainer;

        private var squareButton:Sprite;

        public function GainerBasic_Button() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            this.addChild(squareButton);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;

            gio.button.addEventListener(ButtonEvent.PRESS, buttonPressed);
            gio.button.addEventListener(ButtonEvent.RELEASE, buttonReleased);
            gio.button.addEventListener(ButtonEvent.LONG_PRESS, buttonLongPressed);
        }

        private function buttonLongPressed(e:ButtonEvent):void {
            squareButton.scaleX = 2.0;
            squareButton.scaleY = 2.0;
        }

        private function buttonPressed(e:ButtonEvent):void {
            squareButton.scaleX = 1.5;
            squareButton.scaleY = 1.5;
        }

        private function buttonReleased(e:ButtonEvent):void {
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
