/**
 * Copyright tricksy ( http://wonderfl.net/user/tricksy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gjcr
 */

// forked from hellolight's forked from: [Stardust] HANABI
// forked from paq's [Stardust] HANABI
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import idv.cjcat.stardust.common.clocks.ImpulseClock;
	import idv.cjcat.stardust.common.renderers.Renderer;
	import idv.cjcat.stardust.twoD.emitters.Emitter2D;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;

	[SWF( width=1000, height=600, frameRate=30, backgroundColor=0x000000)]
	public class Main extends Sprite
	{
		private var emitter:Emitter2D;
		private var renderer:Renderer;
		private var container:Sprite;
		private var clock:ImpulseClock;

		public function Main()
		{
			// パーティクルを格納するスプライトを作成。
			container = new Sprite();
			addChild(container);

			// clock.impulse()が呼び出された時に発生するパーティクルの数
			clock = new ImpulseClock(15);
			// エミッターを作成
			emitter = new MyEmitter(clock, container);
			// レンダラーを作成
			renderer = new DisplayObjectRenderer(container);
			renderer.addEmitter(emitter);
			
			// Timer を使って一定期間ごとにパーティクルを作成
			var timer:Timer = new Timer(1300);
			timer.addEventListener(TimerEvent.TIMER, tick);
			timer.start();
			tick(null);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void
		{
			emitter.step();
		}
		
		private function tick(e:TimerEvent):void 
		{
			// パーティクルが発生する位置を変更
			MyEmitter(emitter).point.x = Math.random() * 1000 >> 0;
			MyEmitter(emitter).point.y = Math.random() * 500 >> 0;
			
			// パーティクル作成
			clock.impulse();
		}
	}
}
 
import flash.display.*;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
import idv.cjcat.stardust.common.actions.triggers.LifeTrigger;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Mask;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Damping;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Spawn;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectParent;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

/**
 * エミッター
 */
class MyEmitter extends Emitter2D
{
	private var _point:SinglePoint = new SinglePoint();;
	
	public function MyEmitter(clock:Clock, container:Sprite)
	{
		super(clock);
		
		//-- 初期化
		addInitializer(new DisplayObjectParent(container)); // 
		addInitializer(new DisplayObjectClass(Dust)); // パーティクルのアイテムを指定
		addInitializer(new Position(_point)); // パーティクルの位置を指定
		addInitializer(new Velocity(new LazySectorZone(15, 3))); // パーティクルにかかる力を指定
		addInitializer(new Life(new UniformRandom(50, 10))); // パーティクルのライフを指定
		addInitializer(new Scale(new UniformRandom(1, 0.1))); // パーティクルのスケールを指定
		
		//-- アクションを作成
		var gravity:Gravity = new Gravity(); 
		gravity.addField(new UniformField(0, 0.075));
		var commonActions:CompositeAction = new CompositeAction();
		commonActions.mask = 1 | 2 | 4;
		commonActions.addAction(gravity); // 重力を有効化
		commonActions.addAction(new Age()); // 寿命を有効化
		commonActions.addAction(new DeathLife()); // 消えるを有効化
		commonActions.addAction(new Move()); // 移動を有効化
		commonActions.addAction(new ScaleCurve(0, 10)); // スケール変化を有効化
		commonActions.addAction(new Damping(0.1)); // 減速を有効化
		addAction(commonActions);
		
		//-- パーティクルの軌跡用スポーンを作成
		var trailSpawn:Spawn = new Spawn(new UniformRandom(1, 0)); // スポーンを作成
		trailSpawn.addInitializer(new Mask(2)); // マスクを指定
		trailSpawn.addInitializer(new DisplayObjectClass(Dust)); //　パーティクルの元となるスプライトを指定
		trailSpawn.addInitializer(new Life(new UniformRandom(30, 5))); //　パーティクルの開始ライフを指定
		trailSpawn.addInitializer(new Scale(new UniformRandom(0.4, 0.1))); //　パーティクルの開始スケール値を指定
		
		//-- トリガーを作成
		var headLifeTrigger:LifeTrigger = new LifeTrigger();
		headLifeTrigger.mask = 1;
		headLifeTrigger.triggerEvery = 8; // ライフが5の倍数の時に実行
		headLifeTrigger.addAction(trailSpawn); // 呼び出されたら trailSpawn を作成
		addAction(headLifeTrigger);
		
		//-- パーティクルが死んだときに出すスポーンを作成
		var afterSparkSpawn:Spawn = new Spawn(new UniformRandom(5, 0)); // スポーンを作成
		afterSparkSpawn.addInitializer(new Mask(4)); // マスクを指定
		afterSparkSpawn.addInitializer(new DisplayObjectClass(Dust2)); // パーティクルの元となるスプライトを指定
		afterSparkSpawn.addInitializer(new Velocity(new LazySectorZone(8, 2))); // パーティクルにかかる力を指定
		afterSparkSpawn.addInitializer(new Life(new UniformRandom(40, 15))); // パーティクルの開始ライフを指定
		afterSparkSpawn.addInitializer(new Scale(new UniformRandom(1, 0.4))); // パーティクルの開始スケール値を指定
		
		//-- パーティクルが死んだときに呼び出されるトリガーを作成
		var headDeathTrigger:DeathTrigger = new DeathTrigger();
		headDeathTrigger.mask = 1;
		headDeathTrigger.addAction(afterSparkSpawn);
		addAction(headDeathTrigger);
	}
	
	public function get point():SinglePoint { 
		return _point;
	}
	
	public function set point(value:SinglePoint):void 
	{
		_point = value;
	}
}

/**
 * パーティクル
 */
import flash.display.Sprite;
import frocessing.color.ColorHSV;

class Dust extends Sprite {
	static private var col:int = 0;
	public function Dust() {
		var color:ColorHSV = new ColorHSV(col+=1, 0.7);
		graphics.beginFill(color.value, 0.5);
		graphics.drawCircle(0, 0, 16);
		graphics.beginFill(color.value, 1);
		graphics.drawCircle(0, 0, 8);
		blendMode = BlendMode.ADD;
	}
}

class Dust2 extends Sprite {
	static private var col:int = 0;
	public function Dust2() {
		var color:ColorHSV = new ColorHSV(col+=1, 0.7);
		graphics.beginFill(color.value, 0.5);
		graphics.drawCircle(0, 0, 16);
		graphics.beginFill(color.value, 1);
		graphics.drawCircle(0, 0, 12);
	}
}