/**
 * Copyright dustin.woodard ( http://wonderfl.net/user/dustin.woodard )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gjJU
 */

// forked from ProjectNya's キラキラ (6)
////////////////////////////////////////////////////////////////////////////////
// キラキラ (6)
//
// [AS3.0] TwinkleParticlesクラスだ！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1370
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var twinkle:TwinkleParticles;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(400, 80, 40, Label.CENTER);
            addChild(label);
            label.x = 32;
            label.y = 202;
            label.textColor = 0xFFFFFF;
            label.alpha = 0.3;
            label.text = "Twinkle Particles";
            //
            twinkle = new TwinkleParticles();
            addChild(twinkle);
        }
        
    }

}


//////////////////////////////////////////////////
// TwinkleParticlesクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class TwinkleParticles extends Sprite {
    private var particles:Array;
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var colorTrans:ColorTransform;
    private static var point:Point = new Point();
    private static var blur:BlurFilter;
    private var count:uint = 0;
    private var color:ColorHSV;
    private static var cx:uint = 232;
    private static var cy:uint = 100;
    private static var radius:uint = 100;
    private static var radian:Number = Math.PI/180;

    public function TwinkleParticles() {
        particles = new Array();
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        colorTrans = new ColorTransform(1, 1, 1, 0.8, 0, 0, 0, 0);
        blur = new BlurFilter(16, 16, 3);
        color = new ColorHSV(0, 0.5);
        addEventListener(Event.ENTER_FRAME, create, false, 0, true);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function create(evt:Event):void {
        count += 8;
        color.h = count;
        var particle:Particle = new Particle(color.value);
        var sin:Number = Math.sin(count*radian);
        var cos:Number = Math.cos(count*radian);
        particle.x = cx - 1.2*radius*((1 + 1.4*cos)*sin*Math.abs(sin));
        particle.y = cy + radius*((1 + 2*cos)*cos);
        particle.dx = (particle.x - 232)/160*(Math.random()*0.5 + 0.5);
        particle.dy = (particle.y - 232)/160*(Math.random()*0.5 + 0.5);
        container.addChild(particle);
        particles.push(particle);
    }
    private function update(evt:Event):void {
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.update();
            if (particle.life < 0 || particle.y > stage.stageHeight + 50) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        draw();
    }
    private function draw():void {
        bitmapData.lock();
        bitmapData.draw(container, null, colorTrans);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.filters.GlowFilter;

class Particle extends Sprite {
    private var glow:GlowFilter;
    private var _width:uint = 12;
    private var _height:uint = 18;
    private var blur:uint = 8;
    private static var color:uint = 0xFFFFFF;
    private static var max:uint = 50;
    public var life:int = max;
    private static var radius:Number = 1;
    public var dx:Number = 0;
    public var dy:Number = 0;

    public function Particle(rgb:uint = 0xFFFFFF, w:uint = 12, h:uint = 18, b:uint = 8) {
        _width = w;
        _height = h;
        blur = b;
        glow = new GlowFilter(rgb, 1, blur, blur, 2, 3, false, false);
        draw();
    }

    public function update():void {
        if (life < 0) return;
        life --;
        x += dx;
        y += dy;
        alpha = (life/max < 0.5) ? life*2/max : 1;
        blink();
    }
    private function blink():void {
        if (life%40 == 0) {
            visible = false;
        } else {
            visible = true;
        }
    }
    private function draw():void {
        graphics.beginFill(color);
        graphics.moveTo(0, -_height/2);
        graphics.curveTo(0, 0, -_width/2, 0);
        graphics.curveTo(0, 0, 0, _height/2);
        graphics.curveTo(0, 0, _width/2, 0);
        graphics.curveTo(0, 0, 0, -_height/2);
        graphics.endFill();
        filters = [glow];
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
