/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gjEW
 */

// forked from siouxcitizen's Papervision3DTest01　：3D板を回転させる
//
//3DPlaneオブジェクトにAA顔文字貼りつけ練習
//
//↓下記のソースコードを参考にさせてもらいました
//Text on Cube
//http://wonderfl.net/c/2haB
package {
    import flash.display.Sprite;
    import flash.events.Event;

    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    import flash.display.BitmapData;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.Camera3D;

    import org.papervision3d.render.BasicRenderEngine;
 
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#66CCFF")]
 
    public class MoviePlane extends Sprite
    {
        private var container : Sprite;
        private var viewport  : Viewport3D;
        private var scene     : Scene3D;
        private var camera    : Camera3D;
        private var material  : ColorMaterial;
        private var planeObj  : Plane; 
        private var renderer  : BasicRenderEngine;

        private var planeSize : int = 700;//Planeオブジェクト1辺の長さ
        private var segment   : int = 1;  //面の分割数

        //MoviePlaneクラスのコンストラクタ
        public function MoviePlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //表示するテキストの書体
            var font:String = "";
            //表示するテキストのサイズ
            var size:int = 200;
            //表示するテキストの色
            var fontColor:uint = 0x1A2630;
            //表示するテキストの背景色
            var bgColor:uint = 0x0068B4;
            //テキストデータ設定
            var _format:TextFormat;
            _format = new TextFormat(font, size, fontColor);
            var tf:TextField = new TextField();
            tf.defaultTextFormat = _format;
            tf.text = "( ﾟДﾟ)";
            tf.autoSize = TextFieldAutoSize.LEFT;

            //Bitmapデータ設定
            var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xF);
            bd.draw(tf);

            //マテリアル設定
            var mat:CompositeMaterial = new CompositeMaterial();
            mat.addMaterial(new ColorMaterial(bgColor));
            mat.addMaterial(new BitmapMaterial(bd, true));
            mat.doubleSided = true;

            //Planeオブジェクト生成
            planeObj= new Plane(mat, planeSize, planeSize, segment, segment);
            scene.addChild(planeObj);

            //カメラ設定
            camera = new Camera3D();
            camera.z = -planeSize;
            camera.focus = 50;
            camera.zoom = 1;
 
            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, _enterframe);
        }

        //マウスイベント処理
        private function _enterframe(e:Event):void{
            planeObj.rotationX=viewport.mouseX;
            planeObj.rotationY=viewport.mouseY;
            renderer.renderScene(scene, camera, viewport);
        }
    }
}
