/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gjE3
 */

package
{
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObjectContainer;
    import flash.display.JPEGEncoderOptions;
    import flash.display.JPEGXREncoderOptions;
    import flash.display.PNGEncoderOptions;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    
    /**
     * @author YopSolo
     * A cool native feature for encoding Image PNG/JPEG/JPEGXR
     * http://help.adobe.com/en_US/as3/dev/WS4768145595f94108-17913eb4136eaab51c7-8000.html
     * note that jpgxr can handle transparency
     */
 
    public class Main extends Sprite
    {
        private const FRAMERATE:int = 12;
        
        private var _stageW:int;
        private var _stageH:int;
        private var _halfStageW:int;
        private var _halfStageH:int;
        
        // --
        private var dat:BitmapData;
        
        public function Main():void
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // config stage
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.quality = StageQuality.MEDIUM;
            stage.stageFocusRect = false;
            stage.tabChildren = false;
            
            stage.frameRate = FRAMERATE;
            
            _stageW = stage.stageWidth;
            _stageH = stage.stageHeight;
            _halfStageW = _stageW >> 1;
            _halfStageH = _stageH >> 1;
            
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0x333333);
            bg.graphics.drawRect(0,0,_stageW, _stageH);
            bg.cacheAsBitmap = true;
            addChild( bg );            
            
            // add custom menu
            new CustomMenu(this);
            
            // run app            
            run();
        }
        
        // == APP ==
        private function run():void
        {
            buildTextField(this, 'TIP 8 : Native Image Encoding PNG/JPEG/JPEGXR', 2, 2);
            
            // the image            
            dat = new BitmapData(_halfStageW, _halfStageW, true, 0x0);            
            dat.noise(100);        
            dat.fillRect( new Rectangle(0, 0, _halfStageW>>1, _halfStageW>>1), 0x0);
            
            var bmp:Bitmap = new Bitmap(dat);
            bmp.x = _halfStageW >> 1;
            bmp.y = _halfStageH >> 1;
            addChild(bmp);
            
            // UI
            
            var jpg:PushButton = new PushButton(this, _halfStageW - 200, 400, "Native JPG", _onClickEncodeJPG);
            var png:PushButton = new PushButton(this, _halfStageW - 50, 400, "Native PNG", _onClickEncodePNG);
            var jpgxr:PushButton = new PushButton(this, _halfStageW + 100, 400, "Native JPGXR", _onClickEncodeJPGXR);
        
        }
        
        private function _onClickEncodeJPG(e:MouseEvent):void
        {
            var byteArray:ByteArray = new ByteArray();
            dat.encode(dat.rect, new JPEGEncoderOptions(80), byteArray);
            var fr:FileReference = new FileReference();
            fr.save(byteArray, "image.jpg");
        }
        
        private function _onClickEncodePNG(e:MouseEvent):void
        {
            var byteArray:ByteArray = new ByteArray();
            dat.encode(dat.rect, new PNGEncoderOptions(true), byteArray);
            var fr:FileReference = new FileReference();
            fr.save(byteArray, "image.png");
        }
        
        private function _onClickEncodeJPGXR(e:MouseEvent):void
        {
            var byteArray:ByteArray = new ByteArray();
            dat.encode(dat.rect, new JPEGXREncoderOptions(20, "auto", 0), byteArray);
            var fr:FileReference = new FileReference();
            fr.save(byteArray, "image_jpgxr.jpg");
        }
        
        // == COMMON ==        
        private function buildTextField(doc:DisplayObjectContainer, txt:String, x:int = 0, y:int = 0):TextField
        {
            var fmt:TextFormat = new TextFormat;
            fmt.color = 0xFFFFFF;
            fmt.font = 'Arial'; //(new FONT_HARMONY() as Font).fontName;
            fmt.size = 11; // 8;
            
            var tf:TextField = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.opaqueBackground = 0x333333; // opaque background allow a perfect font rendering even in StageQuality.LOW mode
            tf.selectable = false;
            //tf.embedFonts = true;
            tf.defaultTextFormat = fmt;
            tf.text = txt;
            tf.x = x;
            tf.y = y;
            
            doc.addChild(tf);
            
            return tf;
        }
    
    }

}

import flash.display.Sprite;
import flash.events.ContextMenuEvent;
import flash.net.navigateToURL;
import flash.net.URLRequest;
import flash.ui.ContextMenu;
import flash.ui.ContextMenuItem;

class CustomMenu
{
    
    private const NAME:String = "Flash Tips Collection : 'Native Image Encoding'";
    
    public function CustomMenu(ref:Sprite):void
    {
        var appContextMenu:ContextMenu = new ContextMenu;
        appContextMenu.hideBuiltInItems();
        
        var cmi:ContextMenuItem = new ContextMenuItem(NAME);
        var credits:ContextMenuItem = new ContextMenuItem("by YopSolo");
        appContextMenu.customItems.push(cmi);
        appContextMenu.customItems.push(credits);
        
        cmi.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCollection);
        credits.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCredits);
        
        ref.contextMenu = appContextMenu;
    }
    
    private function _onClickCollection(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr/wp/2012/01/14/flash-tips-collection/'), '_blank');
    }
    
    private function _onClickCredits(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr'), '_blank');
    }
}