/**
 * Copyright bradford.sedito ( http://wonderfl.net/user/bradford.sedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/giqp
 */

//
// forked from tai2's Five Parameters Elephant
//


package 
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;
    
    public class Elephant extends Sprite {

        private const WIDTH:int = 200;
        private const HEIGHT:int = 200;

        // The five parameters
        private var p:Array = new Array(
                new Complex( 50, -30),
                new Complex( 18,   8),
                new Complex( 12, -10),
                new Complex(-14, -60),
                new Complex( 40, -20));

        private var canvas:Sprite;
        
        public function Elephant() {
            canvas = new Sprite();
            canvas.scaleX = stage.stageWidth / WIDTH;
            canvas.scaleY = stage.stageHeight / HEIGHT;
            addChild(canvas); 
            addEventListener(Event.ENTER_FRAME, enterFrame);
            stage.frameRate = 90;
        }
        
        private function enterFrame(event:Event) : void {
            var past:Number = getTimer() * 0.001;
            var ax:Array = new Array(0,      0,      0, p[2].r, 0, p[3].r);
            var bx:Array = new Array(0, p[0].r, p[1].r,      0, 0,      0);
            var ay:Array = new Array(0, p[3].i,      0,      0, 0,      0);
            var by:Array = new Array(0, p[0].i, p[1].i, p[2].i, 0,      0);
            
            var x:Number, y:Number;
            var t:Number, tstart:Number, tend:Number;
            
            canvas.graphics.clear();
            canvas.graphics.beginFill(0xFFFFFF, 1.0);
            canvas.graphics.drawRect(0, 0, WIDTH, HEIGHT);
            canvas.graphics.endFill();

            canvas.graphics.lineStyle(5, 0x000000);

            tstart = 0.4 + 1.3 * Math.PI;
            tend = 2 * Math.PI + 0.9 * Math.PI;
            x = fourier(tstart, ax, bx);
            y = fourier(tstart, ay, by);
            canvas.graphics.moveTo(y + WIDTH / 2, x + HEIGHT / 2);
            for (t = tstart; t < tend; t += (tend - tstart) / 100) {
                x = fourier(t, ax, bx);
                y = fourier(t, ay, by);
                canvas.graphics.lineTo(y + WIDTH / 2, x + HEIGHT / 2);
            }

            tstart = 2 * Math.PI + 0.9 * Math.PI;
            tend = 0.4 + 3.3 * Math.PI;
            var x0:Number = fourier(tstart, ax, bx);
            var y0:Number = fourier(tstart, ay, by);
            for (t = tstart; t < tend; t += (tend - tstart) / 100) {
                x = fourier(t, ax, bx);
                y = fourier(t, ay, by);
                x += Math.sin((y - y0) * Math.PI / 1000) * Math.sin(past) * p[4].r;
                canvas.graphics.lineTo(y + WIDTH / 2, x + HEIGHT / 2);
            }

            canvas.graphics.lineStyle(0, 0x000000);
            canvas.graphics.beginFill(0x000000, 1.0);
            canvas.graphics.drawCircle(-p[4].i + WIDTH / 2, p[4].i + HEIGHT / 2, 5);
            canvas.graphics.endFill();
        }

        private function fourier(t:Number, a:Array, b:Array) : Number
        {
            var r:Number = 0;
            for (var k:int = 0; k < 6; k++) {
                r += a[k] * Math.cos(k * t) + b[k] * Math.sin(k * t);
            }
            return r;
        }

    }

}

class Complex {
    public var r:Number;
    public var i:Number;
    public function Complex(r:Number, i:Number) {
        this.r = r;
        this.i = i;
    }
}
