/**
 * Copyright zsp ( http://wonderfl.net/user/zsp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ghHd
 */

// forked from zsp's flash on 2009-6-14
package {
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "60")]
    public class FlashTest extends Sprite {
        public function FlashTest() {
            main = this;
            initialize();
            addEventListener(Event.ENTER_FRAME, update);
            
        }
    }
}
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    
    import flash.geom.Rectangle;
    import flash.geom.Point;

    const WND_W :int = 465;
    const WND_H :int = 465;
    const WND_HALF_W :int = WND_W/2;

    var main :Sprite;
    var screen :BitmapData = new BitmapData(WND_W,WND_H, true, 0);
    var back_screen :BitmapData = new BitmapData(WND_W,WND_H, false, 0);
    var back_screen_back_buffer :BitmapData = new BitmapData(WND_W,WND_H, false, 0);
    var ct:ColorTransform = new ColorTransform(.98, .85, .97, 0.985);

    var bullets :Vector.<Bullet> = new Vector.<Bullet>;
    var bg :BulletGenerator
    var frame :int = 0;
    var phase :int = 0;

    function initialize():void{
        main.addChild(new Bitmap(back_screen));
        main.addChild(new Bitmap(screen));

        drawBackground();
    }

    function update(e:Event): void{
        
        var sy:int = WND_H - frame%WND_H;
        back_screen.copyPixels(back_screen_back_buffer, new Rectangle(0, sy, WND_W, WND_H), new Point(0, 0));
        back_screen.copyPixels(back_screen_back_buffer, new Rectangle(0, 0, WND_W, sy), new Point(0, WND_H-sy));
        
        screen.colorTransform(screen.rect, ct);

        var f: int = frame %2000;
        if (f==0) bg = new BG01();
        if (f==500) bg = new BG02();
        if (f==1000) bg = new BG03();
        if (f==1500) bg = new BG04();

        bg.generate();

        var i:int = bullets.length;
        while(i--){
            bullets[i].move();
            if(bullets[i].dead) bullets.splice(i,1);
        }

        frame++;
    }

    function drawBackground():void{
        var box_sz:int = 40;

        for(var i:int = 0; i< 500; i++){
            var x:int = Math.random()*WND_HALF_W;
            var y:int = Math.random()*WND_H;
            var c:int = Math.random()*0x7F;            
            var r:Rectangle = new Rectangle(x-box_sz/2, y-box_sz/2,box_sz,box_sz);

            back_screen_back_buffer.fillRect(r,c);
            back_screen_back_buffer.copyPixels(back_screen_back_buffer,new Rectangle(0,0,WND_HALF_W, WND_H), new Point(WND_HALF_W,0));
        }
    }

    class BulletGenerator{
        public function generate():void{}
    }

    class BG01 extends BulletGenerator{
        override public function generate():void{
            var vx :Number = Math.random()*4-2;
            var vy :Number = Math.random()*4-2;
            var vz :Number = Math.random()*0.1-0.05;
            var b:Bullet = new Bullet(116,140,10,vx,vy,vz);
            bullets.push(b);
        }
    }

    class BG02 extends BulletGenerator{
        private var vz:Number =-0.02;
        private var p:int = 0;
        override public function generate():void{

            if (frame %30 ==0) {
                vz = -vz;
                p =(p+1)%2;

                for(var i:int = 0; i< 50; i++){
                    var r:Number = (i*2*Math.PI)/50+ p*0.2;
                    var b:Bullet = new Bullet(116+vz*500,140,10-vz*100,Math.cos(r),Math.sin(r),vz);
                    bullets.push(b);
                }
            }
        }
    }

    class BG03 extends BulletGenerator{
        override public function generate():void{
            if (frame%3 ==0){
                var b: Bullet;
            
                b = new Bullet(116,140,8,Math.cos(frame),Math.sin(frame),0);
                bullets.push(b);

                b = new Bullet(116,140,12,Math.cos(frame+Math.PI/2),Math.sin(frame+Math.PI/2),0);
                bullets.push(b);
            }
        }
    }

    class BG04 extends BulletGenerator{
        private var p:int =-1;
        override public function generate():void{
            if (frame %50==0){
                p =-p;
                var b:Bullet;
            
                for(var i:int = 0; i<10; i++){
                    var r:Number = (i*0.5*Math.PI/10)+Math.PI/4;
                    b = new Bullet(116+p*4,100,10,Math.cos(r), Math.sin(r), (i-5)*0.005*p);
                    bullets.push(b);
                }
            }
        }
    }

    class Bullet{
        public var x:Number;
        public var y:Number;
        public var z:Number;

        public var vx:Number;
        public var vy:Number;
        public var vz:Number;

        public var dead:Boolean;

        public function Bullet(tx:Number, ty:Number, tz:Number ,tvx:Number, tvy:Number, tvz:Number){

            x = tx;
            y = ty;
            z = tz;
            vx = tvx;
            vy = tvy;
            vz = tvz;
            dead = false;
        }

        public function move():void{
            if(x<0 || WND_HALF_W<x) dead = true;
            if(y<0 || WND_H<y) dead = true;
            if(z<0 || 20<z) dead = true;
    
            x +=vx;
            y +=vy;
            z +=vz;

            screen.setPixel32(x-z,y,0xFFFFFFFF);
            screen.setPixel32(x+WND_HALF_W+z,y, 0xFFFFFFFF);
        }
    }
