/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gh3Y
 */

// forked from checkmate's fladdict challenge for professionals
// 2009/07/22 createPatternBitmapData() メソッドの引数を String から uint に変更
// 2009/07/22 ステージクリックで文の色と地の色を交代するよう変更
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    public class Professional extends Sprite {
        
        private var color1:uint;
        private var color2:uint;

        private var bitmapDataVector:Vector.<BitmapData>;

        private const LETTER_WIDTH:uint  = 4;
        private const LETTER_HEIGHT:uint = 6;

        private const FIELD_WIDTH:uint  = 48 * 4;
        private const FIELD_HEIGHT:uint = 48 * 4;
        private var fieldBitmapData:BitmapData = new BitmapData(FIELD_WIDTH, FIELD_HEIGHT, false, 0x0);

        private const CNT_WIDTH:uint  = FIELD_WIDTH  / LETTER_WIDTH;
        private const CNT_HEIGHT:uint = FIELD_HEIGHT / LETTER_HEIGHT;
    
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            color1 = (Math.random() < 0.5) ? 0xFFFFFF : 0x000000;
            color2 = (color1 - 0xFFFFFF) * -1;
            init();
            //enterFrameHandler(null); addChild(new Bitmap(fieldBitmapData)); return;
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
		
        private function clickHandler(e:MouseEvent):void {
            init();
        }
        
        private function init():void {
            decideColor();
            createPattern();
        }
        private function decideColor():void {
            color1 -= 0xFFFFFF
            color1 *= -1;
            color2 = (color1 - 0xFFFFFF) * -1;

            color1 |= 0xFF << 24;
            color2 |= 0xFF << 24;
        }
        private function createPattern():void {
            bitmapDataVector = Vector.<BitmapData>([
                createPatternBitmapData(0xEAAAE0),	// 0
                createPatternBitmapData(0x444440),	// 1
                createPatternBitmapData(0xE2E8E0),	// 2
                createPatternBitmapData(0xE2E2E0),	// 3
                createPatternBitmapData(0xAAE220),	// 4
                createPatternBitmapData(0xE8E2E0),	// 5
                createPatternBitmapData(0xE8EAE0),	// 6
                createPatternBitmapData(0xE22220),	// 7
                createPatternBitmapData(0xEAEAE0),	// 8
                createPatternBitmapData(0xEAE220)	// 9
            ]);
        }
        private function createPatternBitmapData(hex:uint):BitmapData {
            var pattern:Array = [];
            var h:uint = LETTER_HEIGHT;
            while (h--) {
                var bit:int = (hex >> 4 * h) & 0xF;
                var w:uint = 4;
                var array:Array = [];
                while (w--) {
                    array.unshift(bit & 1);
                    bit >>= 1;
                }
                pattern.push(array);
            }
            return BitmapPatternBuilder.build(pattern, [color1, color2]);
        }

        private function enterFrameHandler(event:Event):void {
            var w:uint = CNT_WIDTH;
            var h:uint = CNT_HEIGHT;
            var len:uint = bitmapDataVector.length;
            for (var i:uint = 0; i < h; i++) {
                for (var j:uint = 0; j < w; j++) {
                    var r:uint = Math.random() * len;
                    fieldBitmapData.copyPixels(
                        bitmapDataVector[r],
                        bitmapDataVector[0].rect,
                        new Point(j * LETTER_WIDTH, i * LETTER_HEIGHT)
                    );
                }
            }
	
            graphics.clear();
            graphics.beginBitmapFill(fieldBitmapData);
            graphics.drawRect(0, 0, 480, 480);
            graphics.endFill();
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}