/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ggoT
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	public class Main extends Sprite
	{
		public static const STAGE_W:uint = 600;
		public static const STAGE_H:uint = 400;
		
		private static const _WALL_LEFT:Number = 0;
		private static const _WALL_RIGHT:Number = 600;
		private static const _GROUND_LINE:Number = 300;
		
		private static const _DOT_CONNECT_MAX:int = 4;
		private static const _DERIVATION:int = 2;	
		private static const _MAP_SIZE:Number = 150;
		
		private static const _PI:Number = Math.PI;
		private static const _PI2:Number = 2.0 * _PI;
		private static const _RADIAN90:Number	= _PI * 0.5;
		private static const _RADIAN180:Number	= _PI * 1.0;
		private static const _RADIAN270:Number	= _PI * -0.5;
		private static const _TO_DEGREE:Number	= 180 / _PI;
		
		private static const _GRAVITY:Number = 0.2 / _DERIVATION;
		private static const _ROTATION_RATE:Number = 0.05 / _DERIVATION;	
		private static const _VERTICAL_RATE:Number = 0.2 / _DERIVATION;
		private static const _MOUSE_PULL_RATE:Number = 2.0 / _DERIVATION;
		
		private static const _FRICTION:Number = 0.1 / _DERIVATION;
		private static const _ROTATE_FRICTION:Number = 1 - 0.2 / _DERIVATION;
		private static const _MOUSE_ROTATE_FRICTION:Number = 1 - 0.8 / _DERIVATION;
		private static const _MOUSE_MOVE_FRICTION:Number = 1 - 0.5 / _DERIVATION;
		private static const _GROUND_FRICTION:Number = 1 - 0.2 / _DERIVATION;
		
		private var _dotMap:DotMap;
		private var _particleList:Array = [];
		private var _particleDistance:int;
		private var _w:int;
		private var _h:int;
		
		private var _dragIdX:int = -1;
		private var _dragIdY:int = -1;
		
		private var _bgLayer:Bitmap;
		private var _displayLayer:Bitmap;
		private var _debugLayer:Sprite;
		private var _debugDisplayList:Array = [];
		private var _dragLayer:Sprite;
		private var _dragList:Array = [];
		
		private var _clearBitmap:BitmapData = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
		private var _displayBitmap:BitmapData = new BitmapData(STAGE_W, STAGE_H);
		private var _bgBitmap:BitmapData = new BitmapData(STAGE_W, STAGE_H);
		private var _gradiationBitmap:BitmapData = new BitmapData(STAGE_W, STAGE_H);
		private var _reflectAlphaBitmap:BitmapData = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
		
		private var _rect:Rectangle = new Rectangle(0, 0, STAGE_W, STAGE_H);
		private var _point:Point = new Point();
		private var _refrectPoint:Point = new Point(0, -2*_GROUND_LINE + STAGE_H);
		
		public function Main()
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		private function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.frameRate = 30;
			stage.quality = StageQuality.LOW;
			var bg:Sprite = new Sprite();
			bg.graphics.beginFill(0);
			bg.graphics.drawRect(0, 0, STAGE_W, STAGE_H);
			addChild(bg);
			
			var dotMapList:Array = [
									new MapKirby1(),
									new MapKirby2(),
									new SpongeBob()
									]
			_dotMap = dotMapList[2];
			
			
			addChild(_bgLayer = new Bitmap(_bgBitmap));
			addChild(_displayLayer = new Bitmap(_displayBitmap));
			addChild(_debugLayer = new Sprite());
			addChild(_dragLayer = new Sprite());
			_debugLayer.visible = false;
			_bgLayer.scaleY = -1;
			_bgLayer.y = STAGE_H;
			
			
			
			_w = _dotMap.w+1;
			_h = _dotMap.h+1;
			_particleDistance = _MAP_SIZE / _w;
			var tmpBaceX:Number = (STAGE_W - _MAP_SIZE) / 2;
			var tmpBaceY:Number = 20;
			var x:int, y:int;
			var particle:Particle;

			for (x = 0; x < _w; x++){
				_particleList[x] = [];
				_dragList[x] = [];
				for (y = 0; y < _h; y++){
					
					particle = new Particle();
					var tmpNearDotList:Array = [_dotMap.isDot(x, y), _dotMap.isDot(x-1, y), 
												_dotMap.isDot(x-1, y-1), _dotMap.isDot(x, y-1)];
					particle.connect[0] = (tmpNearDotList[0] || tmpNearDotList[3]) && x < _w-1;	
					particle.connect[1] = (tmpNearDotList[1] || tmpNearDotList[0]) && y < _h-1;	
					particle.connect[2] = (tmpNearDotList[2] || tmpNearDotList[1]) && 0 < x;	
					particle.connect[3] = (tmpNearDotList[3] || tmpNearDotList[2]) && 0 < y;	
					
					
					if (!particle.connect[0] && !particle.connect[1] && !particle.connect[2] && !particle.connect[3]){
						_particleList[x][y] = null;
						continue;
					}
					particle.color = _dotMap.getColor(x, y);
					particle.x = tmpBaceX + _particleDistance * x + Math.random()*3;
					particle.y = tmpBaceY + _particleDistance * y;
					_particleList[x][y] = particle;
					createDragSprite(x, y);
					
				}
			}
			for (x = 0; x < _w; x++){
				for (y = 0; y < _h; y++){
					particle = _particleList[x][y];
					if (particle == null) continue;
					particle.connect[4] = particle.connect[0] && Particle(_particleList[x+1][y]).connect[0];	
					particle.connect[5] = particle.connect[1] && Particle(_particleList[x][y+1]).connect[1];	
					particle.connect[6] = particle.connect[2] && Particle(_particleList[x - 1][y]).connect[2];
					particle.connect[7] = particle.connect[3] && Particle(_particleList[x][y-1]).connect[3];
				}
			}
			
			displayInit();
			
			addEventListener(Event.ENTER_FRAME, frame);
	
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpEvent());
			
		}
		private function createDragSprite(x:int, y:int):void{
			var sprite:Sprite = new Sprite();
			_dragLayer.addChild(sprite);
			_dragList[x][y] = sprite;
			var g:Graphics = sprite.graphics;
			g.beginFill(0x000000, 0);
			g.drawCircle(0, 0, _particleDistance*0.8);
			sprite.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownEvent(x, y));
		}
		
		private function frame(event:Event):void{
			for (var i:int=0; i<_DERIVATION; i++){
				rotate();	
				force();	
				move();	
			}
			draw();
		}
		
		
		
		private function rotate():void{
			var x:int, y:int;
			for (x = 0; x < _w; x++){
				for (y = 0; y < _h; y++){
					var particle:Particle = _particleList[x][y];
					if (particle == null) continue;
					var subParticle:Particle;
					if (particle.connect[0]){
						subParticle = _particleList[x+1][y];
						calcConnectRForce(particle, subParticle, 0);
						calcConnectRForce(subParticle, particle, _RADIAN180);
					}
					if (particle.connect[1]){
						subParticle = _particleList[x][y+1];
						calcConnectRForce(particle, subParticle, _RADIAN90);
						calcConnectRForce(subParticle, particle, _RADIAN270);
					}
					if (particle.connect[4]){	
						subParticle = _particleList[x+2][y];
						calcConnectRForce(particle, subParticle, 0);
						calcConnectRForce(subParticle, particle, _RADIAN180);
					}
					if (particle.connect[5]){
						subParticle = _particleList[x][y+2];
						calcConnectRForce(particle, subParticle, _RADIAN90);
						calcConnectRForce(subParticle, particle, _RADIAN270);
					}
					if (x == _dragIdX && y == _dragIdY) particle.vr *= _MOUSE_ROTATE_FRICTION;
					else particle.vr *= _ROTATE_FRICTION;
			
					particle.radian += particle.vr;
				}
			}
		}
		
		private function calcConnectRForce(particle:Particle, targetParticle:Particle, connectAngle:Number):void{
			var angle:Number = Math.atan2(targetParticle.y - particle.y, targetParticle.x - particle.x);
			particle.vr += ajustRadian(angle - (connectAngle + particle.radian)) * _ROTATION_RATE;
		}
		
		
		
		private function force():void{
			var x:int, y:int;
			for (x = 0; x < _w; x++){
				for (y = 0; y < _h; y++){
					var particle:Particle = _particleList[x][y];
					if (particle == null) continue;
					var subParticle:Particle;
					if (particle.connect[0]){	
						subParticle = _particleList[x+1][y];
						calcConnectFoce(particle, subParticle, 0, _particleDistance);
						calcConnectFoce(subParticle, particle, _RADIAN180, _particleDistance);
					}
					if (particle.connect[1]){	
						subParticle = _particleList[x][y+1];
						calcConnectFoce(particle, subParticle, _RADIAN90, _particleDistance);
						calcConnectFoce(subParticle, particle, _RADIAN270, _particleDistance);
					}
					if (particle.connect[4]){
						subParticle = _particleList[x+2][y];
						calcConnectFoce(particle, subParticle, 0, _particleDistance*2);
						calcConnectFoce(subParticle, particle, _RADIAN180, _particleDistance*2);
					}
					if (particle.connect[5]){
						subParticle = _particleList[x][y+2];
						calcConnectFoce(particle, subParticle, _RADIAN90, _particleDistance*2);
						calcConnectFoce(subParticle, particle, _RADIAN270, _particleDistance*2);
					}
					particle.ay += _GRAVITY;
					if (_dragIdX == x && _dragIdY == y){
						var point:Point = pullForce(particle.x, particle.y, mouseX, mouseY, _MOUSE_PULL_RATE);
						particle.ax += point.x;
						particle.ay += point.y;
						particle.vx *= _MOUSE_MOVE_FRICTION;
						particle.vy *= _MOUSE_MOVE_FRICTION;
					}
				}
			}
		}
		
		private function calcConnectFoce(particle:Particle, targetParticle:Particle, connectAngle:Number, distance:Number):void{
			var toAngle:Number = ajustRadian(connectAngle + particle.radian);
			var toX:Number = particle.x + Math.cos(toAngle) * distance;
			var toY:Number = particle.y + Math.sin(toAngle) * distance;
			var ax:Number = (targetParticle.x - toX) * _VERTICAL_RATE;
			var ay:Number = (targetParticle.y - toY) * _VERTICAL_RATE;
			particle.ax += ax;
			particle.ay += ay;
			targetParticle.ax -= ax;
			targetParticle.ay -= ay;
		}
		
		private function pullForce(x1:Number, y1:Number, x2:Number, y2:Number, rate:Number):Point{
			var point:Point = new Point();
			var distance:Number = calcDistance(x1, y1, x2, y2);
			
			var angle:Number = Math.atan2(y2 - y1, x2 - x1);
			point.x = Math.cos(angle) * distance * rate;
			point.y = Math.sin(angle) * distance * rate;
			return point;
		}
		
		private function calcDistance(x1:Number, y1:Number, x2:Number, y2:Number):Number{
			return Math.sqrt(Math.pow(x2-x1, 2) + Math.pow(y2-y1, 2));
		}
		
		private function ajustRadian(radian:Number):Number{
			return radian - _PI2 * Math.floor( 0.5 + radian / _PI2);
		}
		
		private function move():void{
			var x:int, y:int;
			for (x = 0; x < _w; x++){
				for (y = 0; y < _h; y++){
					var particle:Particle = _particleList[x][y];
					if (particle == null) continue;
					
					
					particle.ax += -_FRICTION * particle.vx;
					particle.ay += -_FRICTION * particle.vy;
					
					
					particle.vx += particle.ax;
					particle.vy += particle.ay;
					particle.x += particle.vx;
					particle.y += particle.vy;
					particle.ax = 0;
					particle.ay = 0;	
					
					
					if (0 < particle.vy && _GROUND_LINE < particle.y){
						particle.y = _GROUND_LINE;
						particle.vy *= -0.8;
						if (particle.vy < -50) particle.vy = -50;
						particle.vx *= _GROUND_FRICTION;
					}
					if (particle.vx < 0 && particle.x < _WALL_LEFT){
						particle.x = _WALL_LEFT;
						particle.vx = 0;
						particle.vy *= _GROUND_FRICTION;
					}else if (0 < particle.vx && _WALL_RIGHT < particle.x){
						particle.x = _WALL_RIGHT;
						particle.vx = 0;
						particle.vy *= _GROUND_FRICTION;
					}
					
					var sprite:Sprite = _dragList[x][y];
					sprite.x = particle.x;
					sprite.y = particle.y;
				}
			}
		}
		
		private var _drawShape:Shape = new Shape();
		
		private function displayInit():void{
			var g:Graphics = _drawShape.graphics;
			g.clear();
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(STAGE_W, STAGE_H, Math.PI / 2, 0, 0);
			g.beginGradientFill(GradientType.LINEAR, [0xffce26, 0x1f5eab], [1, 1], [0, 255], matrix);
			g.drawRect(0, 0, STAGE_W, STAGE_H);
			_gradiationBitmap.draw(_drawShape);
			
			g.clear();
			g.beginGradientFill(GradientType.LINEAR, [0x000000, 0x000000], [0, 0.3], [125, 230], matrix);
			g.drawRect(0, 0, STAGE_W, STAGE_H);
			_reflectAlphaBitmap.draw(_drawShape);
		}
		private function draw():void{
			var g:Graphics = _drawShape.graphics;
			var particle:Particle;
			g.clear();
			var x:int, y:int;
			for (y = 0; y < _h-1; y++){
				for (x = 0; x < _w-1; x++){
					if(!_dotMap.isDot(x, y)) continue;
					g.beginFill(_dotMap.getColor(x, y));
					particle = _particleList[x][y];
					g.moveTo(particle.x, particle.y);
					particle = _particleList[x+1][y];
					g.lineTo(particle.x, particle.y);
					particle = _particleList[x+1][y+1];
					g.lineTo(particle.x, particle.y);
					particle = _particleList[x][y+1];
					g.lineTo(particle.x, particle.y);
					g.endFill();
				}
			}
			
			_displayBitmap.copyPixels(_clearBitmap, _rect, _point);
			_displayBitmap.draw(_drawShape);
			
			
			_bgBitmap.copyPixels(_gradiationBitmap, _rect, _point);
			_bgBitmap.copyPixels(_displayBitmap, _rect, _refrectPoint, _reflectAlphaBitmap, _point, true);
		}
		
		
		private function mouseDownEvent(x:int, y:int):Function{
			return function (event:Event):void{	startBornDrag(x, y);};
		}
		private function mouseUpEvent():Function{
			return function (event:Event):void{	endBornDrag();};
		}
		
		private function startBornDrag(x:int, y:int):void{
			_dragIdX = x;
			_dragIdY = y;
		}
		private function endBornDrag():void{
			_dragIdX = -1;
			_dragIdY = -1;
		}
	}
}

class Particle
{
	public var x:Number = 0;
	public var y:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var ax:Number = 0;
	public var ay:Number = 0;
	
	public var radian:Number = 0;
	public var vr:Number = 0;	
	
	public var color:uint = 0x000000;
	public var connect:Array = [true, true, true, true];	
}
class DotMap	
{
	public var w:uint = 16;
	public var h:uint = 16;
	
	public var pallet:Array = [];	
	public var strPallet:Array = [];	
	public var strMap:String = "";
	public var map:Array = [];	
	
	function DotMap(){
		init();
		readMap();
	}
	protected function init():void{
		w = 16;
		h = 16;
		pallet = [0x000000, 0xDC2900, 0xFFA53B, 0x8B7300];
		strPallet = ["＿", "○", "□", "■"];
		
		strMap =
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■"+
				"■■■■■■■■■■■■■■■■";
				
	}
	private function readMap():void{
		for (var i:int; i<w*h; i++){
			map.push(strPallet.indexOf(strMap.substr(i, 1)));
		}
	}
	
	public function isDot(x:int, y:int):Boolean{
		if (x < 0 || y < 0 || w <= x || h <= y) return false;
		if (map[x + y*w] == 0) return false;
		return true;
	}
	public function getColor(x:int, y:int):uint{
		if (x < 0 || y < 0 || w <= x || h <= y) return 0;
		return pallet[map[x + y*w]];
	}
}
class TestMap extends DotMap
{
	override protected function init():void{
		w = 16;
		h = 16;
		pallet = [0x000000, 0xffffff, 0x000000];
		strPallet = ["＿", "○", "■"];
		strMap =
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"■○■○■○■○■○■○■○■○"+
				"○■○■○■○■○■○■○■○■"+
				"";
	}
}
class MapKirby1 extends DotMap
{
	override protected function init():void{
		w = 16;
		h = 18;
		pallet = [0x000000, 0x6bb24b, 0xffffff, 0x000000];
		strPallet = ["_", "+", "o", "@"];
		strMap =
				"@@@@@@@@@@@@@@@@"+
				"@++++++++++++++@"+
				"@++++++++++++++@"+
				"@+++oooooooo+++@"+
				"@+++oooooooo+++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@+++oooooo+++++@"+
				"@+++oooooo+++++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@+++oo+++++++++@"+
				"@@@+++@@@@+++@@@" +
				"__@+++@__@+++@__" +
				"_@+++++@@+++++@_" +
				"";
	}
}
class MapKirby2 extends DotMap
{
	override protected function init():void{
		w = 33;
		h = 33;
		//------------------yellow-----white-----orange---brown----olive------navy-------grey-----blue-------red
		pallet = [0x000000, 0xfef754, 0xffffff, 0xd9a159, 0x3f2711, 0x968739, 0x4e5f66, 0xafabb1, 0x3cbae1, 0xfb2b4b ];
		strPallet = ["_", "y", "w", "o", "x", "l", "n", "g", "b", "r"];
		strMap =
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+ //
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+ //
				"yyyyyyyyyolyyyyyyyyyyllyyyyyyyyyy"+ //
				"yyyyyyxyylxyyxyyyyxyyxxyyxyyyyyyy"+
				"yyyyyyxxlnlnxxyyyyxxlnglxxyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy"+
				"";
	}
}

class SpongeBob extends DotMap
{
	override protected function init():void{
		w = 17;
		h = 18;
		//------------------dark------yellow-----olive-----darkgreen--white------blue-----rose-----purple-----red-----brown-----orange
		pallet = [0x000000, 0x292300, 0xfff72a, 0x968900, 0x635a00, 0xffffff, 0x2da0e5, 0xffb6a2, 0x712201, 0xf21e12, 0x7d4a11, 0xa5570c ];
		strPallet = ["_",    "#",      "y",       "l",     "g",        ".",      "b",      "r",    "p",      "e",       "n",    "a"];
		strMap =
				"#################"+ //
				"#yylylyyyyylylyy#"+ //
				"#yly####y####yly#"+
				"#yy#....g....#yy#"+
				"#yyg.bb.g.bb.gyy#"+
				"#rrl.b#.l.#b.lrr#"+
				"#rrrllllyllllrrr#"+
				"#rrpyyyyyyyyyprr#"+
				"#yyypp..p..ppyyy#"+
				"#yyyy#ppppp#yyyy#"+
				"#yyyyy#####yyyyy#"+
				"#yyyyyyyyyyyyyyy#"+
				"#......eee......#"+
				"#nnnnnnnennnnnnn#"+
				"#aaaaaaaaaaaaaaa#"+
				"###aaa#####aaa###"+
				"__#yyy#___#yyy#__"+
				"_#aaaaa#_#aaaaa#_"+
				"";
	}
}