/**
 * Copyright yamadori ( http://wonderfl.net/user/yamadori )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ggfx
 */

package {
    import flash.display.Sprite;
    import flash.events.StatusEvent;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    
    public class Main extends Sprite
    {
        private var camera:Camera;
        private var video:Video;
        private var source:BitmapData;
        
        private var sp:Sprite = new Sprite();
        private var maskSp:Sprite = new Sprite();
        
        private var interval:int = 10;
        
        private var bd:BitmapData;
        private var bm:Bitmap;
        
        private const W:Number = stage.stageWidth;
        private const H:Number = stage.stageHeight;
                
        public function Main()
        {
            camera = Camera.getCamera();
            if (camera != null)
            {
                if (camera.muted)
                {
                    Security.showSettings(SecurityPanel.PRIVACY);
                    camera.addEventListener(StatusEvent.STATUS, StatusHandler);
                }
                else
                {
                    ConnectCamera();
                }
            }
            else
            {
                trace("カメラが見つかりません");
            }
        }
        
        private function StatusHandler(e:StatusEvent):void
        {
            if (e.code == "Camera.Unmuted") {
                ConnectCamera();
                camera.removeEventListener(StatusEvent.STATUS, StatusHandler);
            }
        }
        
        private function ConnectCamera():void
        {
            
            camera.setMode(W, H, 30);
            video = new Video(W, H);
            video.attachCamera(camera);
            
            source = new BitmapData(video.width, video.height, false, 0xFFFFFF);
            
            bd = new BitmapData(video.width, video.height, false, 0xFFFFFF);
            bm = new Bitmap(bd);
            //bm.x = stage.stageWidth/2 - video.width/2;
            //bm.y = stage.stageHeight/2 - video.height/2;
            bm.filters = [new BlurFilter(10, 10, BitmapFilterQuality.HIGH)];
            
            addChild(bm);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            source.fillRect(source.rect, 0xFFFFFF);
            source.draw(video);
            
            with (sp.graphics)
            {
                clear();
                lineStyle(0,0,0);
                beginFill(0xFFFFFF);
                drawRect(0,0, source.width, source.height);
                endFill();
            }
            
            var value:uint = 0xFF666666;
            var maskColor:uint = 0xFFFFFFFF;
            source.threshold(source, source.rect, new Point(), "<", value, 0xFF000000, maskColor, true);
            source.threshold(source, source.rect, new Point(), ">", value, 0xFFFFFFFF, maskColor, true);
            
            for (var i:int = 0; i<source.width; i += interval)
            {
                for (var j:int = 0; j<source.height; j += interval)
                {
                    var ac:uint = source.getPixel(i,j);
                    if (ac == 0x000000)
                    {
                        with (sp.graphics)
                        {
                            lineStyle(0, 0, 0);
                            beginFill(ac);
                            drawCircle(i + interval/2, j + interval/2, interval/2);
                            endFill();
                        }
                    }
                }
            }
            sp.filters = [new BlurFilter(20, 20, BitmapFilterQuality.HIGH)];
            source.fillRect(source.rect, 0xFFFFFF);
            source.draw(sp);
            bd.fillRect(bd.rect, 0xFFFFFF);
            bd.threshold(source, bd.rect, new Point(), "<", 0x00999999, 0x0000FF00, 0x00FFFFFF, false);
        }
    }
}