/**
 * Copyright zendenmushi ( http://wonderfl.net/user/zendenmushi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ggGZ
 */

// forked from uwi's Cluster Cluster
// 	バクテリアチックな動きが、今やりたいものに近かったのでforkして実験
//  考えていたものとは別ものになってしまった。重力マウスの影響を多分に受けてます
package {
	import flash.text.TextField;
	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;

	public class ClusterCluster extends Sprite {
		private var _tf : TextField;
		private var _bmd : BitmapData;
		private var _p : Vector.<Number>; // 0:x, 1:y
		private var _a : Vector.<Number>; // 0:x, 1:y // accel
		private var _c : Vector.<uint>;
		private const N : uint = 2000;

		public function ClusterCluster() {
			/*
			_tf = new TextField();
			_tf.width = 465;
			_tf.height = 465;
			addChild(_tf);
			*/

			_p = new Vector.<Number>(N*2);
			_a = new Vector.<Number>(N*2);
			_c = new Vector.<uint>(N);
			for(var i : uint = 0;i < 2*N;i+=2){
				_p[i] = Math.random() * 465;
				_p[i+1] = Math.random() * 465;
				_a[i] = 0;
				_a[i + 1] = 0;
				if ((i & 1) == 0) _c[i/2] = Math.random() * 0xffffff;
				
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			_bmd = new BitmapData(465, 465, false, 0x000000);
			addChild(new Bitmap(_bmd));
		}
		
		// 引力の及ぶ半径
		private var _r : Number = 1.0;
		
		private function onEnterFrame(e : Event) : void
		{
			_r += 0.1;
			if (_r > 200 / 2) _r = 200 / 2;
			
			_bmd.lock();
			_bmd.fillRect(_bmd.rect, 0);
			
			for(var i : uint = 0;i < 2*N;i+=2){

				var moved : Boolean = false;
				for(var u : uint = 0;u < 20;u++){
				var j : uint = Math.random() * N;
				j *= 2;
				if(i == j)continue;
					var dx : Number = _p[j] - _p[i];
					var dy : Number = _p[j+1] - _p[i+1];
					var d2 : Number = dx * dx + dy * dy;
					// 引力
					if(d2 < _r * _r){
						_a[i] = _a[i] + (_p[j] - _p[i]) / _r;
						_a[i + 1] = _a[i + 1] + (_p[j + 1] - _p[i + 1]) / _r;
						moved = true;
					}
					
					// 斥力
					if(d2 < _r * _r / 16){
						_a[i] = _a[i] - (_p[j] - _p[i]) / _r;
						_a[i + 1] = _a[i + 1] - (_p[j + 1] - _p[i + 1])  / _r;
						moved = true;
					}
				}
				_p[i] += _a[i];
				_p[i + 1] += _a[i + 1];
				if (!moved) {
					_a[i] *= 0.8;
					_a[i + 1] *= 0.8;
				}
				
				// できるだけ長く動きが続くように・・・・
				if (_p[i] < 0) _p[i]++;
				if (_p[i] > 465) _p[i]--;
				if (_p[i+1] < 0) _p[i+1]++;
				if (_p[i+1] > 465) _p[i+1]--;
				
				_bmd.setPixel(_p[i], _p[i+1], _bmd.getPixel(_p[i], _p[i+1]) | _c[i/2]);
			}
			_bmd.unlock();
		}
		
		private function tr(...o : Array) : void
		{
			_tf.appendText(o + "\n");
		}
	}
}